package com.tll.store.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 通过参数筛选出符合的门店
 *
 * @author Jxinx
 * @since 2025-06-16
 */
@Data
@ApiModel(description = "通过参数筛选出符合的门店")
@NoArgsConstructor
public class FilterStoreParamRpcDTO extends AbstractExportQueryParam {

    @ApiModelProperty(value = "门店名称/门店编码")
    private String storeDetail;

    @ApiModelProperty(value = "法人姓名")
    private String legalPersonName;

    @ApiModelProperty(value = "法人手机号")
    private String legalPersonPhone;

    @ApiModelProperty(value = "法人姓名/法人手机号")
    private String legalPerson;

    @ApiModelProperty(value = "门店关键词")
    private String storeKeyword;

    @ApiModelProperty(value = "区域经理")
    private String regionManager;

    @ApiModelProperty(value = "门店区域")
    private String storeArea;

    @ApiModelProperty(value = "门店省市区")
    private String district;

    @ApiModelProperty(value = "门店省市区列表")
    private List<String> provincesAndCities;

    @ApiModelProperty(value = "门店类型 0：直营店  1：加盟店", allowableValues = "0,1")
    private Integer storeType;

    @ApiModelProperty(value = "经过筛选一遍后的门店编码")
    private List<String> storeCodingList;

}
