package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.dto.UserIdsRpcDTO;
import com.tll.store.rpc.dto.UserIntegrateRpcDTO;
import com.tll.store.rpc.vo.UserIntegrateRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.Valid;
import java.util.List;

/**
 * 员工信息RPC服务接口
 *
 * @author Auto Generated
 * @date 2025-10-24
 */
@FeignClient(name = Application.NAME, path = UserIntegrateRpcService.URI)
@Validated
public interface UserIntegrateRpcService {
    
    String URI = Application.URI_PREFIX + "/api/userIntegrate";

    /**
     * 根据用户ID获取员工信息
     *
     * @param userId 用户ID
     * @return 员工信息
     */
    @GetMapping(value = "/getByUserId")
    @ApiOperation(value = "根据用户ID获取员工信息")
    ApiResult<UserIntegrateRpcVO> getByUserId(@RequestParam("userId") Long userId);

    /**
     * 根据用户ID集合获取员工信息列表
     *
     * @param userIdsRpcDTO 用户ID集合请求参数
     * @return 员工信息列表
     */
    @PostMapping(value = "/getListByUserIds")
    @ApiOperation(value = "根据用户ID集合获取员工信息列表")
    ApiResult<List<UserIntegrateRpcVO>> getListByUserIds(@RequestBody @Valid UserIdsRpcDTO userIdsRpcDTO);

    /**
     * 根据一级部门ID获取部门员工信息列表
     *
     * @param userIntegrateRpcDTO 请求参数
     * @return 员工信息列表
     */
    @PostMapping(value = "/getListByRootDeptId")
    @ApiOperation(value = "根据一级部门ID获取部门员工信息列表")
    ApiResult<List<UserIntegrateRpcVO>> getListByRootDeptId(@RequestBody @Valid UserIntegrateRpcDTO userIntegrateRpcDTO);

    /**
     * 根据用户名获取员工信息
     *
     * @param userName 用户名
     * @return 员工信息
     */
    @GetMapping(value = "/getByUserName")
    @ApiOperation(value = "根据用户名获取员工信息")
    ApiResult<UserIntegrateRpcVO> getByUserName(@RequestParam("userName") String userName);
}

