package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户门店排行榜实体类
 *
 * @author Generated
 * @since 2024
 */

@Data
public class UserStoreRankingRpcVO implements Serializable {

    @ApiModelProperty(value = "用户id（企微）")
    private String userId;

    @ApiModelProperty(value = "用户姓名")
    private String userName;

    @ApiModelProperty(value = "达标门店数")
    private Integer reachShopNum;

    @ApiModelProperty(value = "未达标门店数")
    private Integer notReachShopNum;

    @ApiModelProperty(value = "目标日均会员数")
    private Integer averageTargetMemberNum;

    @ApiModelProperty(value = "日均完成会员数")
    private Integer averageMemberNum;

    @ApiModelProperty(value = "单店日均拉新")
    private Integer averageShopMemberNum;

    @ApiModelProperty(value = "达标率")
    private String reachSchedule;

    @ApiModelProperty(value = "标签(大于80%:0,20%到80%之间:1,小于20%:2)")
    private Integer emojiTitle;

    @ApiModelProperty(value = "达标率排序(正序)")
    private Integer reachRateSort;

    @ApiModelProperty(value = "督导达标全国排名")
    private Integer supervisorReachSortNationwide;

    @ApiModelProperty(value = "督导所在达标大区排名")
    private Integer supervisorReachSortArea;

    @ApiModelProperty(value = "名下督导未达标数")
    private Integer supervisorNotReachNum;

    @ApiModelProperty(value = "名下区域经理未达标数")
    private Integer areaManagerNotReachNum;

    @ApiModelProperty(value = "名下大区未达标数")
    private Integer bigManagerNotReachNum;

    @ApiModelProperty(value = "职位(区域经理,督导,大区经理,市场总)")
    private String duty;

    @ApiModelProperty(value = "所在区域名称")
    private String areaName;
}