package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.param.save.ReminderInsertDTO;
import com.tll.store.rpc.param.save.ReminderPaymentInsertDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;

/**
 * 违约单服务接口.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */
@FeignClient(name = Application.NAME, path = ReminderRpcService.URI)
@Validated
public interface ReminderRpcService {
    String URI = Application.URI_PREFIX + "/reminder";

    /**
     * 新增数据
     *
     * @param insertDTO 新增数据信息
     * @return 数据ID
     */
    @PostMapping(value = "/addOld")
    ApiResult<Long> add(@RequestBody @Valid ReminderInsertDTO insertDTO);

    /**
     * 违约金缴纳后续操作
     *
     * @param insertDTO 违约金缴纳数据
     * @return 数据ID
     */
    @PostMapping(value = "/afterPaymentOld")
    ApiResult<Long> afterPayment(@RequestBody @Valid ReminderPaymentInsertDTO insertDTO);


}
