package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.vo.RefundRecordVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 退款记录服务
 *
 * @author nian_yh
 * @date 2025/11/17
 */
@FeignClient(name = Application.NAME, path = ReminderFineItemRpcService.URI)
@Validated
public interface RefundRecordService {

    /**
     * URI
     */
    String URI = Application.URI_PREFIX + "/recordClient";

    /**
     * 编辑
     *
     * @return {@link ApiResult }<{@link ? }>
     */
    @PostMapping("/update")
    @ApiOperation("编辑")
    ApiResult<?> edit(@RequestBody RefundRecordVo vo);
}
