package com.tll.store.rpc.dto;

import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.time.LocalDate;

/**
 * 罚款门店巡检报告查询参数
 *
 * @author Jxinx
 * @since 2025-11-10
 */
@Data
@ApiModel(description = "罚款门店巡检报告查询参数")
public class FineStoreInspectReportQueryRpcDTO extends AbstractExportQueryParam {

    private static final long serialVersionUID = 7717274787322714668L;

    @NotBlank(message = "门店编码不能为空")
    @ApiModelProperty(value = "门店编码")
    private String storeCode;

    @ApiModelProperty("门店罚款日期")
    private LocalDate storeFineDate;

}
