package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 列表/详情展示VO
 *
 * @author nian_yh
 * @date 2025/11/10
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@ApiModel("RefundRecordVO - 违约金返还VO")
public class RefundRecordVo implements Serializable {

    @ApiModelProperty(value = "主键id")
    private Long id;

    @ApiModelProperty(value = "申请单号 / 返还单号")
    private String refundNo;

    @ApiModelProperty("罚款单ID")
    private String fineId;

    @ApiModelProperty("罚款单号")
    private String fineNo;

    @ApiModelProperty(value = "门店编号")
    private String storeCode;

    @ApiModelProperty(value = "门店简称")
    private String storeName;

    @ApiModelProperty(value = "门店全称（可选）")
    private String storeFullName;

    @ApiModelProperty(value = "法人姓名")
    private String legalPersonName;

    @ApiModelProperty(value = "法人手机号")
    private String legalPersonPhone;

    @ApiModelProperty(value = "省市区")
    private String provinceCityArea;

    @ApiModelProperty(value = "门店负责人（督导/区域经理/大区经理）")
    private String managerName;

    @ApiModelProperty(value = "罚款金额")
    private BigDecimal fineAmount;

    @ApiModelProperty(value = "剩余待返金额")
    private BigDecimal remainingAmount;

    @ApiModelProperty(value = "罚款支付时间")
    private LocalDateTime finePaymentTime;

    @ApiModelProperty(value = "返还支付时间（实际）")
    private LocalDateTime paymentTime;

    @ApiModelProperty(value = "返还发起人")
    private String initiator;

    @ApiModelProperty(value = "发起说明")
    private String initiateRemark;

    @ApiModelProperty(value = "返还说明（状态文案）")
    private String refundExplain;

    @ApiModelProperty("返还类型")
    private String refundType;

    @ApiModelProperty("返还类型:90-90天返还，365-一年返还")
    private String refundTypeName;

    @ApiModelProperty("返还状态")
    private Integer refundStatus;

    @ApiModelProperty("返还状态：0 - 待返，1 - 返还中，2 - 返还完成，3 - 返还取消，4 - 无需返还，5 - 返还失败，-1 - 未知")
    private String refundStatusName;

    @ApiModelProperty("本次返还金额")
    private BigDecimal refundAmount;

    @ApiModelProperty("收缴金额")
    private BigDecimal collectionAmount;

    @ApiModelProperty("支付流水号（支付中心返回）")
    private String paymentTraceNo;

    @ApiModelProperty("发起类型")
    private String initiatorType;

    @ApiModelProperty("发起类型名称")
    private String initiatorTypeName;

    @ApiModelProperty("审批单号（系统域）")
    private String approvalNo;

    @ApiModelProperty("审批最后备注/退回备注")
    private String approvalRemark;

    @ApiModelProperty("支付重试次数")
    private Integer paymentAttempts;

    @ApiModelProperty("最后一次支付错误信息")
    private String lastPaymentError;

    @ApiModelProperty("父单/关联单（用于90天<->365天互引）")
    private Long parentRefundId;

    @ApiModelProperty("发起时巡检次数快照")
    private Integer inspectionCountSnapshot;

    @ApiModelProperty("发起时间（返还单发起时间）")
    private LocalDateTime initiateTime;
}
