package com.tll.store.rpc.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 门店编码查询 RPC DTO
 *
 * @author system
 * @date 2025-10-16
 */
@Data
@ApiModel("门店编码查询 RPC 请求参数")
public class StoreCodeQueryRpcDTO implements Serializable {

    private static final long serialVersionUID = 2025101600000002L;

    @ApiModelProperty(value = "门店编码", required = true)
    @NotBlank(message = "门店编码不能为空")
    private String storeCode;

}

