package com.tll.store.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 违约金返还通知单记录保存实体.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */

@ApiModel(description = "违约金返还通知单记录保存实体")
@Data
public class ReminderInsertDTO implements Serializable {

    /**
     * 罚款单编号
     */
    @ApiModelProperty(value = "罚款单编号", required = true)
    @NotBlank(message = "罚款单编号不能为空")
    private String reminderId;
    /**
     *门店编号
     */
    @ApiModelProperty(value = "门店编号", required = true)
    @NotBlank(message = "门店编号不能为空")
    private String storeCode;
    /**
     *罚款金额
     */
    @ApiModelProperty(value = "罚款金额", required = true)
    @NotNull(message = "罚款金额不能为空")
    private BigDecimal penaltyAmount;
    /**
     *罚款减少额
     */
    @ApiModelProperty(value = "罚款减少额", required = true)
    @NotNull(message = "罚款减少额不能为空")
    private BigDecimal penaltyReductionAmount;

}
