package com.tll.store.rpc.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author: daidemin
 * Date: 2024/11/13 11:23
 */
@Data
@ApiModel(value = "房源信息")
@NoArgsConstructor
@AllArgsConstructor
public class HousingInfoRpcVO implements Serializable {


    @ApiModelProperty(value = "省")
    private String province;

    @ApiModelProperty(value = "市")
    private String city;

    @ApiModelProperty(value = "区")
    private String district;

    @ApiModelProperty(value = "总面积（㎡）")
    private String totalArea;

    @ApiModelProperty(value = "长（m）")
    private String length;

    @ApiModelProperty(value = "宽（m）")
    private String width;

    @ApiModelProperty(value = "高（m）")
    private String height;

    @ApiModelProperty(value = "转角位   0：没有 1：有")
    private String cornerPosition;

    @ApiModelProperty(value = "主干道   0：没有 1：有")
    private String mainRoad;

    @ApiModelProperty(value = "街巷内   0：没有 1：有")
    private String inTheStreetsAndAlleys;

    @ApiModelProperty(value = "其他   0：没有 1：有")
    private String otherStoreLocation;

    @ApiModelProperty(value = "三相电   0：没有 1：有")
    private String threePhaseElectricity;

    @ApiModelProperty(value = "上下水   0：没有 1：有")
    private String waterSupplyAndDrainage;

    @ApiModelProperty(value = "电信入户   0：没有 1：有")
    private String telecomHomeEntry;

    @ApiModelProperty(value = "房租（万/年）")
    private String rent;

    @ApiModelProperty(value = "门店地址_其他")
    private String storeAddressOther;

    @ApiModelProperty(value = "周边竞争分析")
    private String competitionAnalysis;

    @ApiModelProperty(value = "位置分析")
    private String locationAnalysis;

    @ApiModelProperty(value = "区域保护范围")
    private String territoryProtection;

}
