package com.tll.store.rpc.param.query;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.io.Serializable;

/**
 * @Author: Unicorn
 * @Description: 门店法人信息
 * @Date: 2025/1/13 14:22
 * @Version: 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("门店法人信息")
public class LegalPersonInfoDTO implements Serializable {
    private static final long serialVersionUID = -1986061934398228073L;

    @ApiModelProperty("员工id")
    private Long employeeId;

    @ApiModelProperty("法人")
    private String legalPerson;

    @ApiModelProperty("法人电话")
    private String legalPersonPhone;

    @ApiModelProperty("法人身份证号码")
    private String legalIdentityCard;

    @ApiModelProperty("是否上传营业执照法人身份证正面：是、否")
    private String businessLicenseLegalIdFrontUploaded;

    @ApiModelProperty("是否上传营业执照法人身份证反面：是、否")
    private String businessLicenseLegalIdBackUploaded;

    @ApiModelProperty("法人身份证正面")
    private String businessLicenseLegalIdFront;

    @ApiModelProperty("法人身份证反面")
    private String businessLicenseLegalIdBack;


    @ApiModelProperty("加盟商职业")
    private String franchiseeProfession;

    @ApiModelProperty("加盟商文化程度")
    private String franchiseeEducation;


    @ApiModelProperty("性别    1：男 2：女")
    private String sex;

    @ApiModelProperty("加盟商年龄")
    private Integer franchiseeAge;

    @ApiModelProperty("加盟商配合程度")
    private String franchiseeCooperation;

    @ApiModelProperty("加盟商经济情况")
    private String franchiseeEconomicCondition;

    @ApiModelProperty("联系地址")
    private String contactAddress;

    @ApiModelProperty("邮箱")
    private String contactMail;

    @ApiModelProperty("国籍")
    private String nationality;

    @ApiModelProperty("籍贯")
    private String nativePlace;

    @ApiModelProperty("代理商编号")
    private String agentCode;

    @ApiModelProperty("加盟商编号")
    private String franchiseeCode;

    @ApiModelProperty("加盟状态 0:生效 1:失效 ")
    private Integer status;

    @ApiModelProperty("代理状态 0:生效 1:失效 ")
    private Integer agentStatus;

    @ApiModelProperty("累计加盟门店数")
    private Integer totalFranchiseeStoreNum;

    @ApiModelProperty("活跃门店数")
    private Integer activeStoreNum;

    @ApiModelProperty("代理门店数")
    private Integer totalAgentStoreNum;

    @ApiModelProperty("代理自营门店数")
    private Integer selfManageStoresAmount;

    @ApiModelProperty("代理非自营门店数")
    private Integer nonSelfManageStoresAmount;
}
