package com.tll.store.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 违约通知单记录保存实体.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */

@ApiModel(description = "违约通知单记录保存实体")
@Data
public class ReminderFineInsertDTO implements Serializable {

    /**
     * 违约通知单编号
     */
    @ApiModelProperty(value = "违约通知单编号", required = true)
    @NotBlank(message = "违约通知单编号不能为空")
    private String reminderId;
    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店编号", required = true)
    @NotBlank(message = "门店编号不能为空")
    private String storeCode;


    @ApiModelProperty(value = "罚款日期", required = true)
    @NotBlank(message = "罚款日期不能为空")
    private LocalDate fineDate;

    @ApiModelProperty(value = "利润中心", required = true)
    @NotBlank(message = "利润中心不能为空")
    private String profitCenter;

    @ApiModelProperty(value = "公司名称", required = true)
    @NotBlank(message = "公司名称不能为空")
    private String companyName;

    @ApiModelProperty(value = "公司代码", required = true)
    @NotBlank(message = "公司代码不能为空")
    private String companyCode;

    @ApiModelProperty(value = "开单人", required = true)
    @NotBlank(message = "开单人不能为空")
    private String initiator;

    @ApiModelProperty(value = "开单部门", required = true)
    @NotBlank(message = "开单部门不能为空")
    private String initiatorDept;

    @ApiModelProperty(value = "罚款来源", required = true)
    @NotBlank(message = "罚款来源不能为空")
    private String fineSource;

    @ApiModelProperty(value = "客户编码", required = true)
    @NotBlank(message = "客户编码不能为空")
    private String customerCode;

    @ApiModelProperty(value = "门店名称", required = true)
    @NotBlank(message = "门店名称不能为空")
    private String storeName;

    @ApiModelProperty(value = "法人电话", required = true)
    @NotBlank(message = "法人电话不能为空")
    private String legalPersonPhone;

    @ApiModelProperty(value = "法人", required = true)
    @NotBlank(message = "法人不能为空")
    private String legalPerson;

    @ApiModelProperty(value = "省", required = true)
    @NotBlank(message = "省不能为空")
    private String storeProvince;

    @ApiModelProperty(value = "市", required = true)
    @NotBlank(message = "市不能为空")
    private String storeCity;

    @ApiModelProperty(value = "区", required = true)
    @NotBlank(message = "区不能为空")
    private String storeRegion;

    @ApiModelProperty(value = "门店地址", required = true)
    @NotBlank(message = "门店地址不能为空")
    private String storeAddress;

    @ApiModelProperty(value = "罚款项", required = true)
    @NotBlank(message = "罚款项不能为空")
    private List<ReminderFineItemInsertDTO> fineItemList;

    /**
     * 区域经理
     */
    @ApiModelProperty("区域经理")
    private String areaManager;

    /**
     * 省经理
     */
    @ApiModelProperty("省经理")
    private String provinceManager;

    /**
     * 大区经理
     */
    @ApiModelProperty("大区经理")
    private String bigAreaManager;

}
