package com.tll.store.rpc.dto;

import com.elitescloud.cloudt.common.base.param.QueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 门店批量查询分页 RPC DTO
 * 
 * 性能限制：最大分页大小为 1000，超过将自动限制为 1000
 *
 * @author system
 * @date 2025-10-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("门店批量查询分页 RPC 请求参数")
public class StoreBatchPageRpcDTO extends QueryParam {

    @ApiModelProperty(value = "门店编号列表（可选，不传则查询全部）")
    private List<String> storeCodes;

}

