package com.tll.store.rpc;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.tll.store.Application;
import com.tll.store.rpc.dto.EmployeeNameRpcDTO;
import com.tll.store.rpc.vo.EmployeeDetailRpcVO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * 员工RPC服务接口
 *
 * @author Auto Generated
 * @date 2025-11-17
 */
@FeignClient(name = Application.NAME, path = EmployeeRpcService.URI)
@Validated
public interface EmployeeRpcService {
    
    String URI = Application.URI_PREFIX + "/api/employee";

    /**
     * 根据条件查询员工列表（包含负责门店数）
     *
     * @param employeeNameRpcDTO 查询条件
     * @return 员工详情列表
     */
    @PostMapping(value = "/getEmployeeListByParam")
    @ApiOperation(value = "根据条件查询员工列表（包含负责门店数）")
    ApiResult<List<EmployeeDetailRpcVO>> getEmployeeListByParam(@RequestBody @Valid EmployeeNameRpcDTO employeeNameRpcDTO);
}

