package com.tll.store.rpc.param.save;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 违约金缴纳保存实体.
 *
 * @author taojjun
 * @date 2024-11-05 15:46:22
 */

@ApiModel(description = "违约金缴纳保存实体")
@Data
public class ReminderPaymentInsertDTO implements Serializable {

    /**
     * 罚款单编号
     */
    @ApiModelProperty(value = "罚款单编号", required = true)
    @NotBlank(message = "罚款单编号不能为空")
    private String reminderId;

    /**
     *实际缴纳罚款金额
     */
    @ApiModelProperty(value = "实际缴纳罚款金额", required = true)
    @NotNull(message = "实际缴纳罚款金额不能为空")
    private BigDecimal penaltyRealAmount;
}
