package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@ApiModel("商品DTO查询参数")
public class ItmItemRpcDtoParam implements Serializable {

    /**
     * 商品SKU ID列表
     */
    @ApiModelProperty("商品SKU ID列表")
    private List<Long> itemIds;

    /**
     * 商品SPU ID列表
     */
    @ApiModelProperty("商品SPU ID列表")
    private List<Long> spuIds;

    /**
     * 商品SPU编码列表
     */
    @ApiModelProperty("商品SPU编码列表")
    private List<String> spuCodes;

    /**
     * 商品SPU名称
     */
    @ApiModelProperty("商品SPU名称")
    private String spuName;

    /**
     * 商品SPU名称
     */
    @ApiModelProperty("商品SPU名称/编码 模糊查询")
    private String spuNameCode;

    /**
     * 商品SPU名称2
     */
    @ApiModelProperty("商品SPU名称2")
    private String spuName2;

    /**
     * 商品SKU编号列表
     */
    @ApiModelProperty("商品SKU编号列表")
    private List<String> itemCodes;

    /**
     * 商品名称/编码 模糊查询
     */
    @ApiModelProperty("商品名称/编码 模糊查询")
    private String itemNameCode;

    /**
     * 规格型号列表
     */
    @ApiModelProperty("规格型号列表")
    private List<String> specs;

    /**
     * 商品品牌编号列表
     */
    @ApiModelProperty("商品品牌编号列表")
    private List<String> brands;

    /**
     * 供应商编码列表
     */
    @ApiModelProperty("供应商编码列表")
    private List<String> suppCodes;

    /**
     * 品类编号
     */
    @ApiModelProperty("品类编号")
    private String itemCateCode;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("物料类型 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    /**
     * 商品来源组织列表
     */
    @ApiModelProperty("商品来源组织列表")
    private List<String> itemSources;


    /**
     * 商品SPU编码2列表
     */
    @ApiModelProperty("商品SPU编码2列表")
    private List<String> spuCode2s;

    @ApiModelProperty(value = "产地/原产国")
    private String origin;



}
