package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgOuUserRpcDTO;
import com.elitesland.support.provider.org.dto.OrgUserEmpBuDTO;
import com.elitesland.support.provider.org.param.OrgOuUserRpcDtoParam;
import com.elitesland.support.provider.org.param.OrgUserIdBuParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-07-21
 */
@FeignClient(name = Application.NAME, path = Application.PATH + OrgUserEmpBuRpcService.PATH)
@Validated
public interface OrgUserEmpBuRpcService {
    String PATH = "/orgUserEmpBuRpc";
    /**
     * 根据用户账号ID，获取绑定的员工组织信息
     * @param userId 用户账号ID
     * @return 绑定员工组织信息
     */
    @GetMapping("/findUserEmpBuInfoByUserId")
    ApiResult<OrgUserEmpBuDTO> findUserEmpBuInfoByUserId(@RequestParam("userId") Long userId);

    /**
     * 根据公司ID获取公司下所有员工绑定的用户账号ID
     * @param param 查询参数
     * @return 用户账号ID
     */
    @PostMapping("/findUserIdsByParam")
    ApiResult<List<Long>> findUserIdsByParam(@RequestBody OrgUserIdBuParam param);

    /**
     * 查询公司绑定的用户
     * @param param 查询条件
     * @return 用户信息
     */
    @PostMapping("/findOuUser")
    List<OrgOuUserRpcDTO> findOuUserByParam(@RequestBody OrgOuUserRpcDtoParam param);
}
