package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@ApiModel("商品DTO参数")
public class ItmItemRpcDTO implements Serializable {

    private static final long serialVersionUID = 7537395874820294582L;

    /**
     * 商品SKU ID
     */
    @ApiModelProperty("商品SKU ID")
    private Long id;

    /**
     * 商品SKU编号
     */
    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    /**
     * 商品编号2
     */
    @ApiModelProperty(value = "商品编号2")
    private String itemCode2;

    /**
     * 商品SKU外部编号
     */
    @ApiModelProperty("商品SKU外部编号")
    private String outerCode;

    /**
     * 商品SKU名称
     */
    @ApiModelProperty("商品SKU名称")
    private String itemName;

    /**
     * 商品SKU名称2
     */
    @ApiModelProperty("商品SKU名称2")
    private String itemName2;

    /**
     * 商品SKU简称
     */
    @ApiModelProperty("商品SKU简称")
    private String itemAbbr;

    /**
     * 商品SKU条码
     */
    @ApiModelProperty("商品SKU条码")
    private String barCode;

    /**
     * 商品SKU类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品SKU类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     *商品状态
     */
    @ApiModelProperty(value = "商品状态")
    private String itemStatus3;

    /**
     * 商品SKU规格
     */
    @ApiModelProperty("商品SKU规格")
    private String itemAttr;

    /**
     * 商品SKU品类编号
     */
    @ApiModelProperty("商品SKU品类编号")
    private String itemCateCode;

    /**
     * 品类(SPU)全路径名称
     */
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    /**
     * 品类(SPU)全称
     */
    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 规格型号
     */
    @ApiModelProperty("规格型号")
    private String spec;

    /**
     * 是否需要安装
     */
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    /**
     * 是否启用批次号: true：是，false：否
     */
    @ApiModelProperty("是否启用批次号: true：是，false：否")
    private Boolean lotFlag;

    /**
     * 是否启用序列号
     */
    @ApiModelProperty(value = "是否启用序列号")
    private Boolean snFlag;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    private String packageSpec;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    private String guaranteePeriodUnit;


    /**
     * 是否保修
     */
    @ApiModelProperty(value = "是否保修")
    private Boolean warrantyFlag;

    /**
     * 保修时长
     */
    @ApiModelProperty(value = "保修时长")
    private Integer warrantyPeriod;

    /**
     * 保修时长单位
     */
    @ApiModelProperty(value = "保修时长单位")
    private String warrantyPeriodUnit;


    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    private String allocType;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 税收分类码
     */
    @ApiModelProperty(value = "税收分类码")
    private String taxType;

    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)
     */
    @ApiModelProperty("税率(进项)")
    private BigDecimal taxRate;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 主计量单位 [UDC]COM:UOM
     */
    @SysCode(sys = "yst-supp", mod = "UOM")
    @ApiModelProperty("主计量单位 [UDC]COM:UOM")
    private String uom;
    private String uomName;

    /**
     * 定价计量单位 [UDC]COM:UOM
     */
    @ApiModelProperty("定价计量单位 [UDC]COM:UOM")
    private String pricingUom;

    /**
     * 发运计量单位 [UDC]COM:UOM
     */
    @ApiModelProperty("发运计量单位 [UDC]COM:UOM")
    private String shipUom;

    /**
     * 默认销售单位 [UDC]COM:UOM
     */
    @ApiModelProperty("默认销售单位 [UDC]COM:UOM")
    private String saleUom;

    /**
     * 默认采购单位 [UDC]COM:UOM
     */
    @ApiModelProperty("默认采购单位 [UDC]COM:UOM")
    private String purcUom;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    private String weightUnit;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    private String volumeUnit;

    /**
     * 供应商物料编码
     */
    @ApiModelProperty("供应商物料编码")
    private String suppItemCode;

    /**
     * sku对应的spuId
     */
    @ApiModelProperty("sku对应的spuId")
    private Long spuId;

    /**
     * sku图片名称
     */
    @ApiModelProperty("sku图片名称")
    private String skuImageFileName;

    /**
     * sku图片fileCode
     */
    @ApiModelProperty("sku图片fileCode")
    private String skuImageFileCode;

    /**
     * 产地/原产国
     */
    @ApiModelProperty(value = "产地/原产国")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;

    /**
     * 商品分组 [UDC]ITM:ITEM_GROUP
     */
    @ApiModelProperty(value = "商品分组 [UDC]ITM:ITEM_GROUP")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP")
    private String itemGroup;
    @ApiModelProperty("商品分组")
    private String itemGroupName;

    /**
     * spu图片列表
     */
    @ApiModelProperty("spu图片列表")
    private List<SpuImageDTO> spuImageList;

    /**
     * spu图片列表
     */
    @ApiModelProperty("sku图片列表")
    private List<SpuImageDTO> skuImageList;

    /**
     * 商品冻结状态
     */
    @ApiModelProperty(value = "商品冻结状态")
    private String itemStatus2;


    /**
     * 是否需要售后服务
     */
    @ApiModelProperty(value = "是否需要售后服务")
    private Boolean aftersalesServiceFlagx;

    /**
     * 附件信息
     */
    @ApiModelProperty(value = "附件信息")
    List<ItmItemAttachmentRpcDTO> attchments;


    @ApiModelProperty(value = "证照信息")
    List<ItmItemQualifyRpcDTO> qualifys;



  // ----------------------------------------- 2022-04-28 -----------------------
    /**
     *spu编码
     */
    @ApiModelProperty("spu编码")
    private String spuCode;
    /**
     *商品来源组织
     */
    @ApiModelProperty("商品来源组织")
    private String itemSource;
    /**
     *spu名称
     */
    @ApiModelProperty("spu名称")
    private String spuName;

    /**
     * spu名称2
     */
    @ApiModelProperty(value = "spu名称2")
    private String spuName2;

    /**
     * 商品SPU简称
     */
    @ApiModelProperty("商品SPU简称")
    private String spuAbbr;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    @ApiModelProperty("物料类型名称")
    private String itemType3Name;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE4")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE4")
    private String itemType4;
    @ApiModelProperty("物料类型名称")
    private String itemType4Name;

    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE5")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String itemType5;
    @ApiModelProperty("物料类型名称")
    private String itemType5Name;


    /**
     * 配件类型 [UDC]yst-supp:ACCESSORIES_TYPE
     */
    @ApiModelProperty(value = "配件类型 [UDC]yst-supp:ACCESSORIES_TYPE")
    @SysCode(sys = "yst-supp", mod = "ACCESSORIES_TYPE")
    private String accessoriesType;
    private String accessoriesTypeName;
    /**
     *spu编码2
     */
    @ApiModelProperty("spu编码2")
    private String spuCode2;
    /**
     * 原产国
     */
    @ApiModelProperty("原产国")
    private String menuCountry;

    /**
     *厂家物料编码
     */
    @ApiModelProperty("厂家物料编码")
    private String manuerItemCode;
    /**
     *存储条件
     */
    @ApiModelProperty("存储条件")
    private String storeCondition;
    /**
     *
     */
    @ApiModelProperty("es1")
    private String es1;


    /**
     * es2
     */
    @ApiModelProperty("es2")
    private String es2;

    /**
     * es3
     */
    @ApiModelProperty("es3")
    private String es3;

    /**
     * es4
     */
    @ApiModelProperty("es4")
    private String es4;


    /**
     * es5
     */
    @ApiModelProperty("es5")
    private String es5;

    /**
     * es6
     */
    @ApiModelProperty("es6")
    private String es6;

    /**
     * es7
     */
    @ApiModelProperty("es7")
    private String es7;


    /**
     * es8
     */
    @ApiModelProperty("es8")
    private String es8;


    /**
     * es9
     */
    @ApiModelProperty("es9")
    private String es9;


    /**
     * es10
     */
    @ApiModelProperty("es10")
    private String es10;
    // ----------------------------------------- 2022-04-28 -----------------------


    @ApiModelProperty("是否第三方入驻")
    private String cat;

    @ApiModelProperty("是否有售后拆分件")
    private String cat2;

    @ApiModelProperty("是否护杠物料")
    private String cat3;

}
