package com.elitesland.support.provider.item.dto;

import com.elitescloud.boot.common.annotation.BusinessParam;
import com.elitescloud.boot.common.convert.BooleanToIntegerConverter;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitescloud.cloudt.system.constant.BusinessObjectConstant;
import com.elitesland.support.provider.Application;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Convert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 商品经营目录
 * </p>
 *
 */
@Data
@ApiModel("商品经营目录分页数据")
public class ItmItemBusinessMessageDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = 2280221514194914648L;

    @ApiModelProperty(value = "行号")
    private String lineNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品SKU Id")
    private Long itemId;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("商品经营目录 Id")
    private Long businessId;

    /**
     * 商品SKU编号
     */
    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    /**
     * 商品SKU名称
     */
    @ApiModelProperty("商品SKU名称")
    private String itemName;

    /**
     * sku对应的spuId
     */
    @ApiModelProperty("sku对应的spuId")
    private Long spuId;

    /**
     *spu编码
     */
    @ApiModelProperty("spu编码")
    private String spuCode;

    /**
     *spu名称
     */
    @ApiModelProperty("spu名称")
    private String spuName;

    /**
     * 商品简称
     */
    @ApiModelProperty("商品简称")
    private String itemAbbr;

    /**
     * 外部编号
     */
    @ApiModelProperty("外部编号")
    private String outerCode;

    /**
     * 条码
     */
    @ApiModelProperty("条码")
    private String barCode;

    /**
     * 品类(SPU)编号
     */
    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    @ApiModelProperty(value = "旧物料编码")
    private String oldItemCode;

    /**
     * 品类(SPU)全路径名称
     */
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    /**
     * 品类(SPU)全称
     */
    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    /**
     * 商品类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    /**
     * 商品类型3 [UDC]ITM:ITEM_TYPE3
     */
    @ApiModelProperty("商品类型3 [UDC]ITM:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    /**
     * 商品类型 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_STATUS")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    /**
     * 商品SKU状态
     */
    @ApiModelProperty("商品SKU状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_LIFE_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;
    /**
     * 规格
     */
    @ApiModelProperty("规格")
    private String spec;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    String packageSpec;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    /**
     * 销售计量单位
     */
    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 采购计量单位
     */
    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 要货计量单位
     */
    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    /**
     * 库存计量单位
     */
    @ApiModelProperty("库存计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String storeUom;
    private String storeUomName;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String netWeightUnit;
    private String netWeightUnitName;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;

    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    @SysCode(sys = "yst-supp", mod = "VOLUME_UNIT")
    private String volumeUnit;
    private String volumeUnitName;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;

    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)，小于1的小数，保留8位，四舍五入
     */
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;

    /**
     * 税率描述(进项)
     */
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 税率2描述(销项)
     */
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 是否需要安装
     */
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    /**
     * 是否启用批次号
     */
    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "yst-supp", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司编码")
    private String buCode;

    /**
     * 商品生命状态
     */
    @ApiModelProperty("商品生命状态")
    private String itemLifeStatus;

    /**
     * 标准供应价
     */
    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    /**
     * 采购含税价
     */
    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    /**
     * 销售含税价
     */
    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;

    /**
     * 组套商品明细
     */
    @ApiModelProperty("组套商品明细")
    private List<ItmItemBusinessRpcPagingDTO> groupDtlDTO;

    /*************子件-组套商品明细**************/
    /**
     * 数量(主计量单位的数量)
     */
    @ApiModelProperty(value = "数量(主计量单位的数量)")
    private BigDecimal qty;

    /**
     * 损耗率
     */
    @ApiModelProperty(value = "损耗率")
    private BigDecimal lossRate;

    @ApiModelProperty(value = "产品结构关系编码")
    private Long productStruCode;

    /**
     * 商品关系表头的SKU商品编号
     */
    @ApiModelProperty(value = "商品关系表头的SKU商品编号")
    private String productItemCode;

    /**
     * 商品关系表头的SKU商品名称
     */
    @ApiModelProperty(value = "商品关系表头的SKU商品名称")
    private String productItemName;

    /**
     * 子件-组套商品备注
     */
    @ApiModelProperty(value = "子件-组套商品备注")
    private String productItemRemark;
    /*************子件-组套商品明细**************/

    /**
     * 商品的计量单位
     */
    @ApiModelProperty(value = "商品的计量单位")
    private Map<String, String> uomMap;

    @ApiModelProperty(value = "经销单价")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "经销价")
    private BigDecimal saleAmt;

    @ApiModelProperty(value = "组套单价")
    private BigDecimal packagePrice;

    @ApiModelProperty(value = "组套价")
    private BigDecimal packageAmt;

    @ApiModelProperty(name = "有效小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty(name = "最小起订量")
    private BigDecimal moq;

    @ApiModelProperty(value = "销售计量单位转换系数")
    private BigDecimal saleUomRatio;

    @ApiModelProperty(value = "采购计量单位转换系数")
    private BigDecimal purcUomRatio;

    @ApiModelProperty(value = "辅助计量单位转换系数")
    private BigDecimal uomRatio2;

    @ApiModelProperty(value = "中包装计量单位转换系数")
    private BigDecimal uomRatio3;

    @ApiModelProperty(value = "大包装计量单位转换系数")
    private BigDecimal uomRatio4;

    @ApiModelProperty(value = "定价计量单位转换系数")
    private BigDecimal pricingUomRatio;

    /**
     * 长
     */
    @ApiModelProperty(value = "基本单位-长")
    private BigDecimal length;

    /**
     * 宽
     */
    @ApiModelProperty(value = "基本单位-宽")
    private BigDecimal width;

    /**
     * 高
     */
    @ApiModelProperty(value = "基本单位-高")
    private BigDecimal height;

    /**
     * 尺寸单位 [UDC]yst-supp:LENGTH_UNIT
     */
    @ApiModelProperty(value = "基本单位-尺寸单位 [UDC]yst-supp:LENGTH_UNIT")
    @SysCode(sys = "yst-supp", mod = "LENGTH_UNIT")
    private String lengthUnit;
    private String lengthUnitName;


    /**
     * 毛重2
     */
    @ApiModelProperty(value = "中包装单位-毛重2")
    private BigDecimal grossWeight2;

    /**
     * 重量单位2 [UDC]yst-supp:WEIGHT_UNIT
     */
    @ApiModelProperty(value = "中包装单位-重量单位2 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit2;
    private String weightUnit2Name;

    /**
     * 体积2
     */
    @ApiModelProperty(value = "中包装单位-体积2")
    private BigDecimal volume2;

    /**
     * 体积单位2 [UDC]st-supp:VOLUME_UNIT
     */
    @ApiModelProperty(value = "中包装单位-体积单位2 [UDC]st-supp:VOLUME_UNIT")
    @SysCode(sys = "yst-supp", mod = "VOLUME_UNIT")
    private String volumeUnit2;
    private String volumeUnit2Name;
    /**
     * 对应的商品计量单位2 [UDC]COM:UOM
     */
    @ApiModelProperty(value = "中包装单位-对应的商品计量单位2 [UDC]COM:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightItemUom2;
    private String weightItemUom2Name;

    /**
     * 长度2
     */
    @ApiModelProperty(value = "中包装单位-长度2")
    private BigDecimal length2;

    /**
     * 宽2
     */
    @ApiModelProperty(value = "中包装单位-宽2")
    private BigDecimal width2;

    /**
     * 高2
     */
    @ApiModelProperty(value = "中包装单位-高2")
    private BigDecimal height2;

    /**
     * 尺寸单位2 [UDC]yst-supp:LENGTH_UNIT
     */
    @ApiModelProperty(value = "中包装单位-尺寸单位2 [UDC]yst-supp:LENGTH_UNIT")
    @SysCode(sys = "yst-supp", mod = "LENGTH_UNIT")
    private String lengthUnit2;
    private String lengthUnit2Name;



    /**
     * 毛重3
     */
    @ApiModelProperty(value = "高包装单位-毛重3")
    private BigDecimal grossWeight3;

    /**
     * 重量单位3 [UDC]yst-supp:WEIGHT_UNIT
     */
    @ApiModelProperty(value = "高包装单位-重量单位3 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit3;
    private String weightUnit3Name;

    /**
     * 体积3
     */
    @ApiModelProperty(value = "高包装单位-体积3")
    private BigDecimal volume3;

    /**
     * 体积单位3 [UDC]st-supp:VOLUME_UNIT
     */
    @ApiModelProperty(value = "高包装单位-体积单位3 [UDC]st-supp:VOLUME_UNIT")
    @SysCode(sys = "yst-supp", mod = "VOLUME_UNIT")
    private String volumeUnit3;
    private String volumeUnit3Name;

    /**
     * 对应的商品计量单位3 [UDC]yst-supp:UOM
     */
    @ApiModelProperty(value = "高包装单位-对应的商品计量单位3 [UDC]yst-supp:UOM")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String weightItemUom3;
    private String weightItemUom3Name;

    /**
     * 长度3
     */
    @ApiModelProperty(value = "高包装单位-长度3")
    private BigDecimal length3;

    /**
     * 宽3
     */
    @ApiModelProperty(value = "高包装单位-宽3")
    private BigDecimal width3;

    /**
     * 高3
     */
    @ApiModelProperty(value = "高包装单位-高3")
    private BigDecimal height3;

    /**
     * 尺寸单位3 [UDC]yst-supp:LENGTH_UNIT
     */
    @ApiModelProperty(value = "高包装单位-尺寸单位3 [UDC]yst-supp:LENGTH_UNIT")
    @SysCode(sys = "yst-supp", mod = "LENGTH_UNIT")
    private String lengthUnit3;
    private String lengthUnit3Name;

    /**
     * 存储条件 [UDC]yst-supp:STORE_CONDITION
     */
    @ApiModelProperty(value = "存储条件 [UDC]yst-supp:STORE_CONDITION")
    @SysCode(sys = "yst-supp", mod = "STORE_CONDITION")
    private String storeCondition;
    private String storeConditionName;

    @ApiModelProperty(value = "入库允收天数")
    private Integer allowedInboundDays;


    @ApiModelProperty(value = "门店允收天数")
    private Integer storeAcceptableDays;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty(value = "MRP类型")
    private String mrpType;

    @ApiModelProperty(value = "供应批量类型")
    private String supplyLotType;

    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    /**
     * 商品供应商信息
     */
    @ApiModelProperty("商品供应商信息")
    private List<ItmItemSuppRpcDTO> itmItemSuppDTOS;

    @ApiModelProperty(value = "保鲜期")
    private Integer freshDays;

    @ApiModelProperty(value = "提前预警期")
    private Integer preWarnDays;
}
