package com.elitesland.support.provider.pri.service.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("商品价格主档dto查询条件")
public class PriMainPriceRpcDtoParam implements Serializable {

    private static final long serialVersionUID = -4338427891182297120L;

    @ApiModelProperty("商品ID列表")
    private List<Long> itemIds;

    @ApiModelProperty("商品编号列表")
    private List<String> itemCodes;

    @ApiModelProperty("生效时间点，用于查询指定生效时间点的数据")
    private LocalDateTime validTime;

    @ApiModelProperty("生效时间，时间区间开始，大于等于")
    private LocalDateTime validFrom;

    @ApiModelProperty("失效时间，时间区间结束，小于等于")
    private LocalDateTime validTo;

    @ApiModelProperty(value = "状态 [UDC]COM:COM_ACTIVE")
    private String priceStatus;
}
