package com.elitesland.support.provider.item.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.support.provider.item.dto.ItmSubItemRpcPageDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.support.provider.item.param.ItmSubItemRpcPagingParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 分部商品.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/26 周五
 */
@FeignClient(name = Application.NAME, path = ItmSubItemRpcService.PATH)
public interface ItmSubItemRpcService {
    String PATH = Application.PATH + "/subItem";

    /**
     * 分部商品分页查询
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemBusinessRpcDto")
    PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(@RequestBody ItmItemBusinessRpcPagingParam param);

    /**
     * 分页查询分部商品
     *
     * @param param
     * @return
     */
    @PostMapping("/pageQuery")
    ApiResult<PagingVO<ItmSubItemRpcPageDTO>> pageQuery(@RequestBody ItmSubItemRpcPagingParam param);
}
