package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serial;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/25 周四
 */
@Getter
@Setter
public class ItmSubItemRpcPageDTO extends ItmSubItemBaseRpcDTO {
    @Serial
    private static final long serialVersionUID = 9195618001554333523L;

    @ApiModelProperty("商品SKU Id")
    private Long itemId;

    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    @ApiModelProperty("商品SKU名称")
    private String itemName;

    @ApiModelProperty("sku对应的spuId")
    private Long spuId;

    @ApiModelProperty("spu编码")
    private String spuCode;

    @ApiModelProperty("spu名称")
    private String spuName;

    @ApiModelProperty("商品简称")
    private String itemAbbr;

    @ApiModelProperty("外部编号")
    private String outerCode;

    @ApiModelProperty("条码")
    private String barCode;

    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    @ApiModelProperty("商品类型 [UDC]yst-supp:ITEM_LICENSE_CLASS")
    @SysCode(sys = "yst-supp", mod = "ITEM_LICENSE_CLASS")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    @ApiModelProperty("商品类型3 [UDC]ITM:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    private String itemType3Name;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_STATUS")
    @SysCode(sys = "yst-supp", mod = "ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    @ApiModelProperty("商品SKU状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_LIFE_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty("包装规格")
    String packageSpec;

    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    @ApiModelProperty("库存计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String storeUom;
    private String storeUomName;

    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String netWeightUnit;
    private String netWeightUnitName;

    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;

    @ApiModelProperty("体积")
    private BigDecimal volume;

    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    @SysCode(sys = "yst-supp", mod = "VOLUME_UNIT")
    private String volumeUnit;
    private String volumeUnitName;

    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    @ApiModelProperty("供应商ID")
    private Long suppId;
    @ApiModelProperty("供应商编号")
    private String suppCode;
    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("税码(进项)")
    private String taxCode;
    @ApiModelProperty("税率(进项)，小于1的小数，保留8位，四舍五入")
    private BigDecimal taxRate;
    @ApiModelProperty("税率描述(进项)")
    private String taxRateDesc;

    @ApiModelProperty("税码2(销项)")
    private String taxCode2;
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;
    @ApiModelProperty("税率2描述(销项)")
    private String taxRate2Desc;


    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    @ApiModelProperty("是否启用批次号")
    private Boolean lotFlag;

    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;


    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    @SysCode(sys = "yst-supp", mod = "TIME_UNIT")
    private String guaranteePeriodUnit;
    private String guaranteePeriodUnitName;

    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    @ApiModelProperty("公司编码")
    private String buCode;


    @ApiModelProperty("商品生命状态")
    private String itemLifeStatus;

    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;

    @ApiModelProperty("组套商品明细")
    private List<ItmItemBusinessRpcPagingDTO> groupDtlDTO;

    /*************子件-组套商品明细**************/

    @ApiModelProperty(value = "数量(主计量单位的数量)")
    private BigDecimal qty;

    @ApiModelProperty(value = "损耗率")
    private BigDecimal lossRate;

    @ApiModelProperty(value = "产品结构关系编码")
    private Long productStruCode;

    @ApiModelProperty(value = "商品关系表头的SKU商品编号")
    private String productItemCode;


    @ApiModelProperty(value = "商品关系表头的SKU商品名称")
    private String productItemName;

    /**
     * 子件-组套商品备注
     */
    @ApiModelProperty(value = "子件-组套商品备注")
    private String productItemRemark;
    /*************子件-组套商品明细**************/

    @ApiModelProperty(value = "商品的计量单位")
    private Map<String, String> uomMap;

    @ApiModelProperty(value = "经销单价")
    private BigDecimal salePrice;

    @ApiModelProperty(value = "经销价")
    private BigDecimal saleAmt;

    @ApiModelProperty(value = "组套单价")
    private BigDecimal packagePrice;

    @ApiModelProperty(value = "组套价")
    private BigDecimal packageAmt;

    @ApiModelProperty(value = "辅助计量单位转换系数")
    private BigDecimal uomRatio2;

    @ApiModelProperty(name = "有效小数位数")
    private Integer decimalPlaces;

    @ApiModelProperty(name = "最小起订量")
    private BigDecimal moq;
}
