package com.elitesland.support.provider.pri.cache.client;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.common.TenantClient;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class PriPriceCacheClient {

    private static final String PRI_CACHE_STATUS_KEY = "pri_price_cache_status:";

    private static RedisUtils redisUtils;

    static {
        redisUtils = SpringUtil.getBean(RedisUtils.class);
    }

    /**
     * 缓存定价元素配置
     *
     * @param cacheList
     */
    public static void cacheConf(List<PriPriceConfCache> cacheList) {
        redisUtils.set(PriPriceConfCache.PRI_CONF_CACHE_KEY + TenantClient.getSessionTenant().getId(), cacheList);
    }

    /**
     * 获取定价元素配置
     *
     * @return
     */
    public static List<PriPriceConfCache> findConfCache() {
        String cacheKey = PriPriceConfCache.PRI_CONF_CACHE_KEY + TenantClient.getSessionTenant().getId();
        Object cache = redisUtils.get(cacheKey);
        if (cache == null) {
            return new ArrayList<>();
        }
        return (List<PriPriceConfCache>) cache;
    }

    public static void cachePriorityConf(List<PriPricePriorityConfCache> cacheList) {
        redisUtils.set(PriPricePriorityConfCache.PRI_PRIORITY_CONF_CACHE_KEY + TenantClient.getSessionTenant().getId(), cacheList);
    }

    public static List<PriPricePriorityConfCache> findPriorityConfCache() {
        String cacheKey = PriPricePriorityConfCache.PRI_PRIORITY_CONF_CACHE_KEY + TenantClient.getSessionTenant().getId();
        Object cache = redisUtils.get(cacheKey);
        if (cache == null) {
            return new ArrayList<>();
        }
        return (List<PriPricePriorityConfCache>) cache;
    }

    public static void clearCacheStatus() {
        if (TenantClient.getSessionTenant() == null) {
            return;
        }
        String cacheKey = PRI_CACHE_STATUS_KEY + TenantClient.getSessionTenant().getId();
        redisUtils.del(cacheKey);
    }

    public static Boolean cacheFinished() {
        String cacheKey = PRI_CACHE_STATUS_KEY + TenantClient.getSessionTenant().getId();
        Object o = redisUtils.get(cacheKey);
        if (o == null) {
            return false;
        }
        if (((int) o) == 1) {
            return true;
        }
        return false;
    }

    public static void cacheFinish() {
        if (TenantClient.getSessionTenant() == null) {
            return;
        }
        String cacheKey = PRI_CACHE_STATUS_KEY + TenantClient.getSessionTenant().getId();
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime end = now.withHour(23).withMinute(30);
        long validMills = LocalDateTimeUtil.between(now, end).toMillis();
        redisUtils.set(cacheKey, 1, validMills, TimeUnit.MILLISECONDS);
    }

    public static void cachePrice(List<PriPriceCache> priPriceCaches) {
        if (CollectionUtil.isEmpty(priPriceCaches)) {
            return;
        }

        Long tenantId = TenantClient.getSessionTenant().getId();
        String dateStr = LocalDateTimeUtil.format(LocalDate.now(), "yyyyMMdd");
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime end = LocalDateTimeUtil.endOfDay(now);
        long validMills = LocalDateTimeUtil.between(now, end).toMillis();
        for (PriPriceCache priPriceCach : priPriceCaches) {
            String key = priPriceCach.getCacheKey(tenantId, dateStr);
            redisUtils.set(key, priPriceCach, validMills, TimeUnit.MILLISECONDS);
        }
    }

    public static void removePrice(List<PriPriceCache> priPriceCaches) {
        if (CollectionUtil.isEmpty(priPriceCaches)) {
            return;
        }

        Long tenantId = TenantClient.getSessionTenant().getId();
        String dateStr = LocalDateTimeUtil.format(LocalDate.now(), "yyyyMMdd");
        List<String> keys = new ArrayList<>();
        for (PriPriceCache priPriceCach : priPriceCaches) {
            String key = priPriceCach.getCacheKey(tenantId, dateStr);
            keys.add(key);
        }
        redisUtils.del(keys.toArray(new String[keys.size()]));
    }

    public static List<PriPriceCache> findPrice(List<String> keyList) {
        if (CollectionUtil.isEmpty(keyList)) {
            return new ArrayList<>();
        }
        List<PriPriceCache> result = new ArrayList<>();
        List list = redisUtils.multiGet(keyList);
        for (Object obj : list) {
            if (obj == null) {
                continue;
            }
            result.add((PriPriceCache) obj);
        }
        return result;
    }
}
