package com.elitesland.support.provider.item.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/2/26
 */
@Data
@ApiModel(value = "商品主表入参", description = "商品主表入参")
public class ItmItemPartParam implements Serializable {
    private static final long serialVersionUID = -7823635172914645177L;

    /**
     * 品项id集合
     */
    @ApiModelProperty("品项id集合")
    private List<Long> ids;

    /**
     * 品项编号集合
     */
    @ApiModelProperty("品项编号集合")
    private List<String> itemCodes;

    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    private String itemName;

    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    private String brand;

    /**
     * 品牌编码集合
     */
    @ApiModelProperty("品牌编码集合")
    private List<String> brands;

    /**
     * 品牌名
     */
    @ApiModelProperty("品牌名")
    private String brandName;

    /**
     * 品项类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("品项类型 [UDC]yst-supp:ITEM_LICENSE_CLASS")
    private String itemType;
}
