package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-04-28
 */
@Data
@ApiModel("公司DTO数据结构")
public class OrgOuRpcDTO implements Serializable {

    private static final long serialVersionUID = 5952811508556472231L;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    private Long id;

    /**
     * 组织id
     */
    @ApiModelProperty("组织id")
    private Long buId;

    /**
     * 组织编号
     */
    @ApiModelProperty("组织编号")
    private String buCode;

    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String buName;

    /**
     * 公司编号
     */
    @ApiModelProperty("公司编号")
    private String ouCode;

    /**
     * 公司名称
     */
    @ApiModelProperty("公司名称")
    private String ouName;

    @ApiModelProperty(value = "贸易公司id")
    private Long tradeOuId;

    @ApiModelProperty(value = "贸易公司编码")
    private String tradeOuCode;

    @ApiModelProperty(value = "贸易公司名称")
    private String tradeOuName;

    /**
     * 公司简称
     */
    @ApiModelProperty("公司简称")
    private String ouAbbr;

    /**
     * 字母缩写
     */
    @ApiModelProperty("字母缩写")
    private String abbrAlpha;

    /**
     * 公司类型
     */
    @ApiModelProperty("公司类型")
    private String ouType;

    /**
     * 公司状态 [UDC]COM:STATUS_ACTIVEORNO
     */
    @ApiModelProperty("公司状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String ouStatus;

    /**
     * 法人公司ID
     */
    @ApiModelProperty("法人公司ID")
    private Long legalOuId;

    /**
     * 本位币
     */
    @ApiModelProperty("本位币")
    private String ouCurr;

    /**
     * 地址号
     */
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 核算编码
     */
    @ApiModelProperty("核算编码")
    private String externalCode;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 纳税人识别号
     */
    @ApiModelProperty("纳税人识别号")
    private String taxerCode;

    /**
     * 开户银行
     */
   @ApiModelProperty(value = "开户银行")
    private String invBankName;

    /**
     * 银行账户
     */
    @ApiModelProperty(value = "银行账户")
    private String invBankAcc;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String invPicPhone;

    /**
     * 联系地址
     */
    @ApiModelProperty(value = "联系地址")
    private String invAddress;

    /**
     * 开票联系人
     */
    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    /**
     * 外部系统类型
     */
    @ApiModelProperty(value = "外部系统类型")
    private String outerSysType;

    @ApiModelProperty("收付款方式：[UDC]COM:PAY_METHOD")
    @SysCode(sys = "yst-supp", mod = "PAY_METHOD")
    private String payCollectMethod;
    private String payCollectMethodName;

    /**
     * 开票抬头
     */
    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

}
