package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.OrgStoreDetailRpcDTO;
import com.elitesland.support.provider.org.dto.OrgStoreWhDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + OrgStoreRpcService.PATH)
@Validated
public interface OrgStoreRpcService {
    String PATH = "/orgStoreRpc";

    @GetMapping("/{id}")
    OrgStoreDetailRpcDTO get(@PathVariable("id") Long id);

    @GetMapping("/getByCode")
    OrgStoreDetailRpcDTO getByCode(@RequestParam("storeCode") String storeCode);

    @PostMapping("/storeWh/codes")
    ApiResult<List<OrgStoreWhDTO>> listWhByCode(@RequestBody List<String> storeCodes);

    @PostMapping("/queryByIds")
    List<OrgStoreDetailRpcDTO> queryByIds(@RequestBody List<Long> ids);

    @PostMapping("/queryByStoreCodes")
    List<OrgStoreDetailRpcDTO> queryByStoreCodes(@RequestBody List<String> storeCodes);
}
