package com.elitesland.support.provider.item.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.*;
import com.elitesland.support.provider.item.param.*;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author Chris
 * @date 2021-04-27
 */
@FeignClient(name = Application.NAME, path = Application.PATH + ItmItemRpcService.PATH)
@Validated
public interface ItmItemRpcService {
    String PATH = "/itmItemRpc";
    /**
     * 保存商品数据
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 保存参数
     * @return dto
     */
    @PostMapping("/saveItem")
    Long saveItem(@RequestBody ItmItemSpuSaveRpcParam param);

    /**
     * 获取商品信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些商品基本信息，用于渲染
     * 2. 检查商品是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemRpcDto")
    List<ItmItemRpcDTO> findItemRpcDtoByParam(@RequestBody ItmItemRpcDtoParam param);

    /**
     * 获取商品基础信息列表
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemBaseRpcDto")
    List<ItmItemBaseRpcDTO> findItemBaseRpcDtoByParam(@RequestBody ItmItemBaseRpcParam param);

    /**
     * 获取商品信息分页列表ItmItemRpcPagingDTO  sku层面
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("findItemRpcPaging")
    PagingVO<ItmItemRpcPagingDTO> findItemRpcPagingByParam(@RequestBody ItmItemRpcPagingParam param);

    /**
     * 获取商品信息分页列表ItmItemRpcPagingDTO  spu层面
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("findItemSpuRpcPaging")
    PagingVO<ItmItemSpuRpcPagingDTO> findItemSpuRpcPagingByParam(@RequestBody ItmItemSpuRpcPagingParam param);



    /**
     * 由于单商品会有很多单位转换数据
     * 为了防止获取单位转换接口被调用多次，该接口每次返回指定商品的所有单位转换信息
     * 获取商品单位转换系数列表，该接口应用如下场景
     * 1. 根据商品ID获取该商品所有的单位转换数据，由调用方自己做二次过滤
     * 12
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemUomConvDto")
    List<ItmItemUomConvRpcDTO> findItemUomConvDtoByParam(@RequestBody ItmItemUomConvRpcDtoParam param);


    /**
     * 根据商品id   获取小类的 产品段值码  财务商品分类码 费用类码 财务分类
     * 同时返回该小类的中类大类编码
     *
     * @param itemIds 商品id 列表
     * @return dto
     */
    @PostMapping("/findItemCateContPropDtoByItemId")
    ItmItemCateContrPropRpcDTO findItemCateContPropDtoByItemId(@RequestBody List<Long> itemIds);

    /**
     * 根据品类编码 查询管控参数
     *
     * @param param 查询条件param
     * @return ItemCateContrPropRpcDTO
     */
    @PostMapping("/findItemCateContrProp")
    List<ItemCateContrPropRpcDTO> findItemCateContrPropByParam(@RequestBody ItemCateContrPropParam param);

    /**
     * 根据param查询商品信息带经营目录SKU明细的BU
     *
     * @param param 查询条件
     * @return 商品信息
     */
    @PostMapping("/findItemSkuBusinessByParam")
    List<ItmItemSkuBusinessRpcDTO> findItemSkuBusinessByParam(@RequestBody ItmItemSkuBusinessRpcDtoParam param);

    /**
     * 根据param查询商品经营目录信息
     *
     * @param param 查询条件
     * @return List<ItmItemBusinessRpcDTO>
     */
    @PostMapping("/findItmItemBusiness")
    List<ItmItemBusinessRpcDTO> findItmItemBusinessByParam(@RequestBody ItmItemBusinessRpcDtoParam param);

    /**
     * 获取经营目录商品信息分页列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemBusinessRpcDto")
    PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(@RequestBody ItmItemBusinessRpcPagingParam param);

    /**
     * 获取经营目录商品信息分页列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping("/findItemBusinessRpcDtoOrThaliByParam")
    PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoOrThaliByParam(@RequestBody ItmItemBusinessRpcPagingParam param);

    /**
     * 根据小类的品类编码获取对应一级品类编码，二级品类编码，三级品类编码的列表
     * <p>
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     * @return ItmItemCateCodeRpcDTO
     */
    @PostMapping("/findCateCodeReItemCateCode")
    ItmItemCateCodeRpcDTO findCateCodeReItemCateCode(@RequestBody ItmItemCateCodeParam param);


    /**
     * 根据param 查询商品状态配置信息列表
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     * @return ItmBusinessTypeRpcDTO
     */
    @PostMapping("/findItmItemStatusConfig")
    List<ItmItemStatusConfigRpcDTO> findItmItemStatusConfigByParam(@RequestBody ItmItemStatusConfigRpcParam param);


    /**
     * 根据时间和商品信息 校验商品是否被冻结
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param 校验参数
     */
    @PostMapping("/checkItemLifeStatusConfig")
    void checkItemLifeStatusConfigByParam(@RequestBody ItmCheckLifeStatusRpcParam param);

    /**
     * 根据大类名称获取对应的品类数据
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param param
     */
    @PostMapping("/getItemCateInfoByBigCateName")
    Map<String, Map<String, Map<String, String>>> getItemCateInfoByBigCateName(@RequestBody ItmItemCateNameParam param);


    /**
     * 根据商品id、业务单位、数量  获取商品单位转换后的数据转换后的数据
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param params params
     * @return 转换后的数据
     */
    @PostMapping("/getItemUomConvNumberByList")
    List<ItmItemUomConvCalcRpcDTO> getItemUomConvNumberByList(@RequestBody List<ItmItemUomConvCalcParam> params);

    /**
     * 根据商品id、从单位、到单位、从数量  获取商品单位转换后的数据
     *
     * 返回的数量，四舍五入保留8位小数
     * 由业务端按照系统配置，展示相应的单价、数量、金额至前端
     *
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param params params
     * @return 转换后的数据
     */
    @PostMapping("/selectItemUomConvByParam")
    List<ItemUomConvRpcDTO> selectItemUomConvByParam(@RequestBody List<ItemUomConvRpcParam> params);


    /**
     * 根据商品、单位 获取商品标准供应价、采购含税价、销售含税价的数据
     *
     * 返回的数量，四舍五入保留8位小数
     * 由业务端按照系统配置，展示相应的单价、数量、金额至前端
     *
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param params params
     * @return 转换后的数据
     */
    @PostMapping("/selectItemConvPriceByParam")
    List<ItemConvPriceRpcDTO> selectItemConvPriceByParam(@RequestBody @Validated List<ItemConvPriceRpcParam> params);

    /**
     * 根据商品SKU编码查询商品的计量单位
     *
     * @param param 入参
     * @return 出参
     */
    @PostMapping("/selectItemUomByParam")
    List<ItmItemUomRpcDTO> selectItemUomByParam(@RequestBody ItmItemUomRpcParam param);


    /**
     * 获取品类树全部数据
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     * @return 转换后的数据
     */
    @GetMapping("/itmItemCateSearchTree")
    List<ItmItemCateTreeRpcDTO> itmItemCateSearchTree();

    /**
     * 通过条件查询符合的商品id
     * 用于其他域一些只需要商品id的场景
     * @param param 查询条件
     * @return id集合
     */
    @PostMapping("/findItemId")
    List<Long> findItemIdByParam(@RequestBody ItmItemRpcDtoParam param);

    /**
     * 校验商品是否 过期 ，根据商品证照信息进行校验
     * true 表示已过期  false 表示未过期
     * @param itemIds 商品id
     * @return 是否过期
     */
    @PostMapping("/checkItemQualifyWhetherExpired")
    Map<Long, Boolean> checkItemQualifyWhetherExpired(@RequestBody List<Long> itemIds);

    /**
     * 商品 -商城 spu详情
     * @param param 入参
     * @return 商品详情
     */
    @PostMapping("/mall/detail")
    ItmItemMallSpuDetailDTO searchDetail(@RequestBody ItmItemMallSpuDetailParam param );

    /**
     * 通过品类编码获取最小品类
     * @param param 品类编码
     * @return 最小品类
     */
    @PostMapping("/findLeafCateByCateCode")
    Map<String, List<ItmItemCateRpcDTO>> findLeafCateByCateCode(@RequestBody ItmItemCateCodeParam param);


    /**
     *
     * 根据入参查询允发期商品组信息
     * @param param 入参
     * @return 允发期商品组的数据
     *
     */
    @PostMapping("/findAllowShipItemGroup")
    List<AllowShipItemGroupRpcDTO> findAllowShipItemGroupByParam(@RequestBody AllowShipItemGroupRpcParam param);

    /**
     *
     * 根据入参查询允发期商品组信息-允发期商品组主表和明细平级汇总展示
     * @param param 入参
     * @return 允发期商品组的主表和明细数据
     *
     */
    @PostMapping("/findAllowShipItemGroupLevel")
    List<AllowShipItemGroupLevelRpcDTO> findAllowShipItemGroupLevelByParam(@RequestBody AllowShipItemGroupRpcParam param);

    /**
     * 商品查询，仅查询库存操作所需字段
     * @param itemIds
     * @return
     */
    @PostMapping("/findItemForStk")
    List<ItmItemStkRpcDTO> findItemForStk(@RequestBody List<Long> itemIds);

    @PostMapping("/findSimpleItem")
    List<ItmItemSimpleRpcDTO> findSimpleItem(@RequestBody List<Long> itemIds);

    /**
     * 获取商品品类全路径
     * @param itemCateCode 品类编号
     * @return 全路径
     */
    @PostMapping("/findItemCatePath")
    List<ItmItemCateSimpleTreeRpcDTO> findItemCatePath(@RequestBody String itemCateCode);

    /**
     * 查询商品图片
     * @return 查询商品图片
     */
    @PostMapping("/findSkuImgByItemIds")
    List<ItmItemAttachmentProviderDTO> findSkuImgByItemIds(@RequestBody List<Long> itemIds);

    @PostMapping("/findLotRpcDTOS")
    List<ItmItemLotRpcDTO> findLotRpcDTOS(@RequestBody List<Long> itemIds);

    @PostMapping("/findAllLeafCateId")
    List<Long> findAllLeafCateId(@RequestBody List<Long> cateIds);

    @GetMapping("/findItemIdByCodeName")
    List<Long> findItemIdByCodeName(@RequestParam(value = "itemCode", required = false) String itemCode,
                                    @RequestParam(value = "itemName", required = false) String itemName,
                                    @RequestParam(value = "codeName", required = false) String codeName);
}
