package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "库存调用查询商品", description = "库存调用查询商品")
public class ItmItemStkRpcDTO implements Serializable {

    private static final long serialVersionUID = -8863745052232596865L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    private String itemType;

    @ApiModelProperty("品项类型2 [UDC]ITM:ITEM_TYPE2")
    private String itemType2;

    @ApiModelProperty("商品类型3 [UDC]yst-supp:ITEM_TYPE3")
    private String itemType3;

    @ApiModelProperty("商品分类编码")
    private String itemCateCode;

    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    @ApiModelProperty("分类名称")
    private String itemCateFullName;

    @ApiModelProperty("基本计量单位")
    private String uom;

    @ApiModelProperty("辅助计量单位")
    private String uom2;

    @ApiModelProperty("税率 进项VAT")
    private BigDecimal taxRate;

    @ApiModelProperty("税率 进项VAT")
    private String taxRateNo;

    @ApiModelProperty("税率 销项VAT")
    private String taxRateNo2;

    @ApiModelProperty("税率 销项VAT")
    private BigDecimal taxRateOut;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("是否启用批次号: true：是，false：否")
    private Boolean lotFlag;

    private List<UomConv> uomConvList;

    @Getter
    @Setter
    public static class UomConv {
        @ApiModelProperty(value = "从单位 [UDC]COM:UOM")
        private String fromUom;

        @ApiModelProperty(value = "到单位 [UDC]COM:UOM")
        private String toUom;

        @ApiModelProperty(value = "转换系数")
        private BigDecimal ratio;

        @ApiModelProperty(value = "反向系数")
        private BigDecimal revertRatio;
    }
}
