package com.elitesland.support.provider.org.dto;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author Tristan
 * @date 2021/4/1
 */
@Data
@ApiModel("门店表明细返回参数")
public class OrgStoreDetailRpcDTO implements Serializable {

    private static final long serialVersionUID = -3552120547826181134L;

    @ApiModelProperty(value = "申请单号")
    private String applyNo;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "门店id")
    private Long id;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "所属公司ID")
    private Long ouId;

    @ApiModelProperty(value = "所属公司名称")
    private String ouName;

    @ApiModelProperty(value = "所属公司编码")
    private String ouCode;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "所属组织ID")
    private Long pid;
    private String pname;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty(value = "门店对应组织ID")
    private Long buId;

    /**
     * 所属组织名称
     */
    @ApiModelProperty(value = "所属组织名称")
    private String pName;

    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店ID")
    private String storeCode;

    /**
     * 门店编号
     */
    @ApiModelProperty(value = "门店编号")
    private String storeCode2;

    /**
     * 门店名称
     */
    @ApiModelProperty(value = "门店名称")
    private String storeName;


    /**
     * 门店类型
     */
    @ApiModelProperty(value = "门店类型")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE")
    private String storeType;
    private String storeTypeName;

    /**
     * 经营性质
     */
    @ApiModelProperty(value = "经营性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE2")
    private String storeType2;
    private String storeType2Name;

    /**
     * 店面性质
     */
    @ApiModelProperty(value = "店面性质")
    @SysCode(sys = "yst-supp", mod = "STORE_TYPE3")
    private String storeType3;
    private String storeType3Name;



    /**
     * 门店状态
     */
    @ApiModelProperty(value = "门店状态")
    @SysCode(sys = "yst-supp", mod = "STORE_STATUS")
    private String storeStatus;
    private String storeStatusName;

    /**
     * 门店间数
     */
    @ApiModelProperty(value = "门店间数")
    private Long storeRoom;

    /**
     * 店铺面积
     */
    @ApiModelProperty(value = "店铺面积")
    private BigDecimal storeArea;

    /**
     * 员工数量
     */
    @ApiModelProperty(value = "员工数量")
    private Long storeEmpNum;


    /**
     * 门店标签
     */
    @ApiModelProperty(value = "门店标签")
    private List<String> storeTags;

    /**
     * 门店标签名称
     */
    @ApiModelProperty(value = "门店标签名称")
    private List<String> storeTagNames;


    /**
     * 门店负责人
     */
    @ApiModelProperty(value = "门店负责人")
    private String storeManager;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String storeContPhone;

    /**
     * 店铺介绍
     */
    @ApiModelProperty(value = "店铺介绍")
    private String storeIntrodu;



    @ApiModelProperty(value = "店面等级")
    private String storeLevel;
    private String storeLevelName;



    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("地址号")
    private Long addrNo;

    /**
     * 营业时间段
     */
    @ApiModelProperty(value = "营业时间段")
    private String openTimeSpan;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty("记录创建者")
    private String creator;

    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("记录最后更新者")
    String updater;

    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;

    @ApiModelProperty("地址信息")
    private OrgAddrAddressRpcDTO addressRpcDTO;

    @ApiModelProperty("业务员ID")
    private Long agentEmpId;

    @ApiModelProperty("业务员名称")
    private String agentEmpName;

    @ApiModelProperty("业务员编码")
    private String agentEmpCode;

    @ApiModelProperty("客户编码")
    private String custCode;

    @ApiModelProperty("客户号")
    private String custCode2;

    @ApiModelProperty("客户名称")
    private String custName;

    @ApiModelProperty("客户简称")
    private String custAbbr;

    @ApiModelProperty(value = "品牌id")
    private String brandId;

    @ApiModelProperty(value = "品牌编码")
    private String brandCode;

    @ApiModelProperty(value = "  品牌名称")
    private String brandName;

    @ApiModelProperty(value = "品牌中文名")
    private String brandEnName;

    @ApiModelProperty(value = "区域")
    @SysCode(sys = "yst-supp", mod = "REGION")
    private String region;

    private String regionName;
}
