package com.elitesland.support.provider.flexField.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.flexField.dto.FlexFieldStructDRpcDTO;
import com.elitesland.support.provider.flexField.dto.FlexFieldValueRpcDTO;
import com.elitesland.support.provider.flexField.param.FlexFieldShowNamesQueryRpcParam;
import com.elitesland.support.provider.flexField.param.FlexFieldStructDQueryRpcParam;
import com.elitesland.support.provider.flexField.param.FlexFieldValueQueryRpcParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 弹性域RPC接口
 */
@FeignClient(name = Application.NAME, path = Application.PATH + FlexFieldRpcService.PATH)
@Validated
public interface FlexFieldRpcService {
    String PATH = "/flexField";
    /**
     * 根据弹性域名称或者表单名称查询弹性域字段明细
     * @param flexFieldStructDQueryRpcParam
     * @return
     */
    @PostMapping(value = "/queryFlexFieldStructDS")
    ApiResult<List<FlexFieldStructDRpcDTO>> queryFlexFieldStructDS(@RequestBody FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam);

    /**
     * 查询弹性域字段值
     * @param flexFieldValueQueryRpcParams
     * @return
     */
    @PostMapping(value = "/queryFlexFieldValues")
    ApiResult<Map<String, FlexFieldValueRpcDTO>> queryFlexFieldValues(@RequestBody List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams);

    /**
     * 翻译弹性域udc,值集，表值集名称翻译
     * @param flexFieldShowNameQueryRpcParam
     * @return
     */
    @PostMapping(value = "/queryFlexFieldShowNames")
    ApiResult<Map<Long,Map<String, String>>> queryFlexFieldShowNames(@RequestBody FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam);
}
