package com.elitesland.support.provider.item.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

@Data
@ApiModel(value = "商品简要信息", description = "商品简要信息")
public class ItmItemLotRpcDTO implements Serializable {

    private static final long serialVersionUID = -8863745052232596865L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("条码")
    private String barcode;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty(value = "是否启用批次号")
    private Boolean lotFlag;

    @ApiModelProperty(value = "保质期天数")
    private Integer guaranteeDays;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long spuId;

    @ApiModelProperty("品项编号")
    private String spuCode;

    /**
     * 详细描述
     */
    @ApiModelProperty(name = "详细描述")
    private String itemDescribe;

    @ApiModelProperty(name = "基本单位毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty(name = "基本单位体积")
    private BigDecimal volume;

    public Long fetchImageId() {
        if (Objects.equals(itemCode, spuCode)) {
            return spuId;
        }
        return id;
    }
}
