package com.elitesland.support.provider.org.param;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/03/13
 * @Version 1.0
 * @Content:
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OrgOuComRpcParam implements Serializable {
    private static final long serialVersionUID = 609160723370100822L;

    /**
     * 公司编号/名称/简称，支持模糊查询
     */
    @ApiModelProperty(value = "公司编号/名称/简称，支持模糊查询")
    private String ouCodeName;

    /**
     * 公司类型 [UDC]ORG:OU_TYPE
     */
    @ApiModelProperty(value = "公司类型 [UDC]ORG:OU_TYPE")
    private String ouType;

    /**
     * Anti-公司类型，不等于这个类型的数据 [UDC]ORG:OU_TYPE
     */
    @ApiModelProperty(value = "Anti-公司类型，不等于这个类型的数据 [UDC]ORG:OU_TYPE")
    private String antiOuType;

    /**
     * 是否需要全部数据,0/默认：全部数据（除草稿和已逻辑删除的数据）；1：正常状态数据；2：已停用状态数据
     */
    @ApiModelProperty("是否需要全部数据,0/默认：全部数据（除草稿和已逻辑删除的数据）；1：正常状态数据；2：已停用状态数据")
    private Integer allDataFlag;

    @ApiModelProperty("公司归类")
    private List<String> ouType2List;
    @ApiModelProperty("公司类型")
    private List<String> ouTypeList;
    @ApiModelProperty("公司状态")
    private List<String> ouStatusList;

    @ApiModelProperty("公司编码")
    private List<String> ouCodeList;

    @ApiModelProperty("是否只查结算来源公司: true 是 false 否")
    private Boolean pathOuCodeFlag;

    @ApiModelProperty("结算路径的当前公司")
    private String pathOuCode;
}
