package com.elitesland.support.provider.item.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmItemBusinessRpcPagingDTO;
import com.elitesland.support.provider.item.dto.ItmItemUomConvDTO;
import com.elitesland.support.provider.item.dto.ItmSubItemRpcPageDTO;
import com.elitesland.support.provider.item.param.ItmItemBusinessRpcPagingParam;
import com.elitesland.support.provider.item.param.ItmSubItemRpcPagingParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 分部商品.
 *
 * @author Kaiser（wang shao）
 * @date 2025/9/26 周五
 */
@FeignClient(name = Application.NAME, path = ItmSubItemRpcService.PATH)
public interface ItmSubItemRpcService {
    String PATH = Application.PATH + "/subItem";

    /**
     * 分部商品分页查询
     *
     * @param param dto 分页查询条件，每个条件使用 and 关联
     * @return dto
     */
    @ApiOperation(value = "分部商品分页查询", notes = "分页查询条件，每个条件使用 and 关联")
    @PostMapping("/findItemBusinessRpcDto")
    PagingVO<ItmItemBusinessRpcPagingDTO> findItemBusinessRpcDtoByParam(@RequestBody ItmItemBusinessRpcPagingParam param);

    /**
     * 分页查询分部商品
     *
     * @param param
     * @return
     */
    @ApiOperation(value = "分页查询分部商品")
    @PostMapping("/pageQuery")
    ApiResult<PagingVO<ItmSubItemRpcPageDTO>> pageQuery(@RequestBody ItmSubItemRpcPagingParam param);

    /**
     * 获取商品转换信息
     *
     * @param itemId
     * @return
     */
    @ApiOperation(value = "根据商品ID获取单位转换关系")
    @GetMapping(value = "/uomConv/getByItemId")
    ApiResult<ItmItemUomConvDTO> getItemUomConv(@RequestParam(name = "itemId") Long itemId);

    /**
     * 批量获取商品转换信息
     *
     * @param itemIds
     * @return
     */
    @ApiOperation(value = "根据商品ID批量获取商品转换信息")
    @PostMapping(value = "/uomConv/listByItemId")
    ApiResult<List<ItmItemUomConvDTO>> listItemUomConv(@RequestBody Set<Long> itemIds);
}
