package com.elitesland.support.provider.org.param;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitesland.support.provider.org.dto.OrgBusinessScopeRpcDTO;
import com.elitesland.support.provider.org.dto.OrgQualifyReviewRpcDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgQualifyReviewMainRpcParam extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -4556831321181172117L;

    @ApiModelProperty("来源编码")
    private String origCode;
    @ApiModelProperty(value = "临时编码（保存没有提交审核的编码）")
    private String codeTemp;
    @ApiModelProperty("编码")
    private String code;
    @ApiModelProperty("名称")
    private String name;

    /**
     * 数据来源
     */
    @ApiModelProperty(value = "数据来源")
    private String dataSource;

    @ApiModelProperty(value = "资质文审")
    private List<OrgQualifyReviewRpcParam> orgQualifyReviewRpcParams;
    @ApiModelProperty("经营范围")
    private List<OrgBusinessScopeRpcParam> orgBusinessScopeRpcParams;
    @ApiModelProperty(value = "资质文审")
    private List<OrgQualifyReviewRpcDTO> orgQualifyReviewRpcDTOS;
    @ApiModelProperty("经营范围")
    private List<OrgBusinessScopeRpcDTO> orgBusinessScopeRpcDTOS;
}
