package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@ApiModel("商品DTO参数")
public class ItmItemRpcDTO implements Serializable {

    private static final long serialVersionUID = 7537395874820294582L;

    /**
     * 商品SKU ID
     */
    @ApiModelProperty("商品SKU ID")
    private Long id;

    /**
     * 商品SKU编号
     */
    @ApiModelProperty("商品SKU编号")
    private String itemCode;

    /**
     * 商品编号2
     */
    @ApiModelProperty(value = "商品编号2")
    private String itemCode2;

    /**
     * 商品SKU外部编号
     */
    @ApiModelProperty("商品SKU外部编号")
    private String outerCode;

    /**
     * 商品SKU名称
     */
    @ApiModelProperty("商品SKU名称")
    private String itemName;

    /**
     * 商品SKU名称2
     */
    @ApiModelProperty("商品SKU名称2")
    private String itemName2;

    /**
     * 商品SKU简称
     */
    @ApiModelProperty("商品SKU简称")
    private String itemAbbr;

    /**
     * 商品SKU条码
     */
    @ApiModelProperty("商品SKU条码")
    private String barCode;

    /**
     * 商品SKU类型 [UDC]ITM:ITEM_TYPE
     */
    @ApiModelProperty("商品SKU类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;
    /**
     * 物料类型 [UDC]ITM:ITEM_TYPE2
     */
    @ApiModelProperty(value = "物料类型 [UDC]ITM:ITEM_TYPE2")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE2")
    private String itemType2;
    private String itemType2Name;

    /**
     * 商品SKU状态 [UDC]ITM:ITEM_STATUS
     */
    @ApiModelProperty("商品SKU状态 [UDC]ITM:ITEM_STATUS")
    private String itemStatus;

    /**
     *商品状态
     */
    @ApiModelProperty(value = "商品状态")
    private String itemStatus3;


    @ApiModelProperty(value = "商品规格(JSON格式)")
    private String itemAttr;
    @ApiModelProperty(value = "商品规格名称(多个;分隔)")
    private String itemAttrName;

    /**
     * 商品SKU品类编号
     */
    @ApiModelProperty("商品SKU品类编号")
    private String itemCateCode;

    /**
     * 品类(SPU)全路径名称
     */
    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    /**
     * 品类(SPU)全称
     */
    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    /**
     * 品牌
     */
    @ApiModelProperty("品牌")
    private String brand;

    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    private String brandName;

    /**
     * 规格型号
     */
    @ApiModelProperty("规格型号")
    private String spec;

    /**
     * 是否需要安装
     */
    @ApiModelProperty("是否需要安装")
    private Boolean installFlag;

    /**
     * 是否启用批次号: true：是，false：否
     */
    @ApiModelProperty("是否启用批次号: true：是，false：否")
    private Boolean lotFlag;

    /**
     * 是否启用序列号
     */
    @ApiModelProperty(value = "是否启用序列号")
    private Boolean snFlag;

    /**
     * 包装规格
     */
    @ApiModelProperty("包装规格")
    private String packageSpec;

    /**
     * 效期管理标识
     */
    @ApiModelProperty("效期管理标识")
    private Boolean guaranteeFlag;

    /**
     * 保质期时长
     */
    @ApiModelProperty("保质期时长")
    private Integer guaranteePeriod;

    /**
     * 保质期单位 [UDC]COM:TIME_UNIT
     */
    @ApiModelProperty("保质期单位 [UDC]COM:TIME_UNIT")
    private String guaranteePeriodUnit;


    /**
     * 是否保修
     */
    @ApiModelProperty(value = "是否保修")
    private Boolean warrantyFlag;

    /**
     * 保修时长
     */
    @ApiModelProperty(value = "保修时长")
    private Integer warrantyPeriod;

    /**
     * 保修时长单位
     */
    @ApiModelProperty(value = "保修时长单位")
    private String warrantyPeriodUnit;


    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer guaranteeDays;

    /**
     * 配货类型 [UDC]ITM:ALLOC_TYPE
     */
    @ApiModelProperty("配货类型 [UDC]ITM:ALLOC_TYPE")
    @SysCode(sys = "yst-supp", mod = "ALLOC_TYPE")
    private String allocType;
    private String allocTypeName;

    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    private Long suppId;

    /**
     * 供应商编号
     */
    @ApiModelProperty("供应商编号")
    private String suppCode;

    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    private String suppName;



    /**
     * 税码(进项)
     */
    @ApiModelProperty("税码(进项)")
    private String taxCode;

    /**
     * 税率(进项)
     */
    @ApiModelProperty("税率(进项)")
    private BigDecimal taxRate;

    /**
     * 税码2(销项)
     */
    @ApiModelProperty("税码2(销项)")
    private String taxCode2;

    /**
     * 税率2(销项)
     */
    @ApiModelProperty("税率2(销项)")
    private BigDecimal taxRate2;

    /**
     * 关税税率
     */
    @ApiModelProperty("关税税率")
    private BigDecimal taxRateTariff;

    /**
     * 基本计量单位
     */
    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    /**
     * 辅助计量单位
     */
    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    /**
     * 中包装计量单位
     */
    @ApiModelProperty("中包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom3;
    private String uom3Name;

    /**
     * 大包装计量单位
     */
    @ApiModelProperty("大包装计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom4;
    private String uom4Name;

    /**
     * 计量单位5
     */
    @ApiModelProperty("计量单位5")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom5;
    private String uom5Name;

    /**
     * 销售计量单位
     */
    @ApiModelProperty("销售计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String saleUom;
    private String saleUomName;

    /**
     * 采购计量单位
     */
    @ApiModelProperty("采购计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String purcUom;
    private String purcUomName;

    /**
     * 定价计量单位
     */
    @ApiModelProperty("定价计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String pricingUom;
    private String pricingUomName;

    /**
     * 发运计量单位
     */
    @ApiModelProperty("发运计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String shipUom;
    private String shipUomName;

    /**
     * 要货计量单位
     */
    @ApiModelProperty("要货计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String orderUom;
    private String orderUomName;

    /**
     * 毛重
     */
    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    /**
     * 净重
     */
    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("净重单位 [UDC]yst-supp:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String netWeightUnit;
    private String netWeightUnitName;

    /**
     * 重量单位 [UDC]COM:WEIGHT_UNIT
     */
    @ApiModelProperty("重量单位 [UDC]COM:WEIGHT_UNIT")
    @SysCode(sys = "yst-supp", mod = "WEIGHT_UNIT")
    private String weightUnit;
    private String weightUnitName;
    /**
     * 体积
     */
    @ApiModelProperty("体积")
    private BigDecimal volume;

    /**
     * 体积单位 [UDC]COM:VOLUME_UNIT
     */
    @ApiModelProperty("体积单位 [UDC]COM:VOLUME_UNIT")
    private String volumeUnit;

    /**
     * 供应商物料编码
     */
    @ApiModelProperty("供应商物料编码")
    private String suppItemCode;

    /**
     * sku对应的spuId
     */
    @ApiModelProperty("sku对应的spuId")
    private Long spuId;

    /**
     * sku图片名称
     */
    @ApiModelProperty("sku图片名称")
    private String skuImageFileName;

    /**
     * sku图片fileCode
     */
    @ApiModelProperty("sku图片fileCode")
    private String skuImageFileCode;

    @ApiModelProperty("sku图片url")
    private String skuImageUrl;

    /**
     * 产地
     */
    @ApiModelProperty(value = "产地")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;

    /**
     * 商品分组 [UDC]yst-supp:ITEM_GROUP
     */
    @ApiModelProperty(value = "商品分组 [UDC]yst-supp:ITEM_GROUP")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP")
    private String itemGroup;
    @ApiModelProperty("商品分组")
    private String itemGroupName;

    /**
     * 商品分组2 [UDC]yst-supp:ITEM_GROUP2
     */
    @ApiModelProperty(value = "商品分组2 [UDC]yst-supp:ITEM_GROUP2")
    @SysCode(sys = "yst-supp", mod = "ITEM_GROUP2")
    private String itemGroup2;
    @ApiModelProperty("商品分组2")
    private String itemGroup2Name;

    /**
     * spu图片列表
     */
    @ApiModelProperty("spu图片列表")
    private List<SpuImageDTO> spuImageList;

    /**
     * spu图片列表
     */
    @ApiModelProperty("sku图片列表")
    private List<SpuImageDTO> skuImageList;

    /**
     * 商品冻结状态
     */
    @ApiModelProperty("商品SKU状态")
    @SysCode(sys = "yst-supp", mod = "ITEM_LIFE_STATUS")
    private String itemStatus2;
    private String itemStatus2Name;
    /**
     * 发货模式 [UDC]yst-supp:SHIPPING_METHOD
     */
    @ApiModelProperty(value = "发货模式 [UDC]yst-supp:SHIPPING_METHOD")
    private String shippingMethod;




    /**
     * 附件信息
     */
    @ApiModelProperty(value = "附件信息")
    List<ItmItemAttachmentRpcDTO> attchments;


    @ApiModelProperty(value = "证照信息")
    List<ItmItemQualifyRpcDTO> qualifys;



    // ----------------------------------------- 2022-04-28 -----------------------
    /**
     *spu编码
     */
    @ApiModelProperty("spu编码")
    private String spuCode;
    /**
     *商品来源组织
     */
    @ApiModelProperty("商品来源组织")
    private String itemSource;
    /**
     *spu名称
     */
    @ApiModelProperty("spu名称")
    private String spuName;

    /**
     * spu名称2
     */
    @ApiModelProperty(value = "spu名称2")
    private String spuName2;

    /**
     * 商品SPU简称
     */
    @ApiModelProperty("商品SPU简称")
    private String spuAbbr;

    /**
     * 商品类型3 [UDC]yst-supp:ITEM_TYPE3
     */
    @ApiModelProperty(value = "商品类型3 [UDC]yst-supp:ITEM_TYPE3")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE3")
    private String itemType3;
    @ApiModelProperty("商品类型3名称")
    private String itemType3Name;

    /**
     * 商品类型4 [UDC]yst-supp:ITEM_TYPE4
     */
    @ApiModelProperty(value = "商品类型4 [UDC]yst-supp:ITEM_TYPE4")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE4")
    private String itemType4;
    @ApiModelProperty("商品类型4名称")
    private String itemType4Name;

    /**
     * 商品类型5 [UDC]yst-supp:ITEM_TYPE5
     */
    @ApiModelProperty(value = "商品类型5 [UDC]yst-supp:ITEM_TYPE5")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE5")
    private String itemType5;
    @ApiModelProperty("商品类型5名称")
    private String itemType5Name;

    /**
     *spu编码2
     */
    @ApiModelProperty("spu编码2")
    private String spuCode2;
    /**
     * 原产国
     */
    @ApiModelProperty("原产国")
    private String menuCountry;

    /**
     *厂家物料编码
     */
    @ApiModelProperty("厂家物料编码")
    private String manuerItemCode;
    /**
     *存储条件
     */
    @ApiModelProperty(value = "存储条件 [UDC]yst-supp:STORE_CONDITION")
    @SysCode(sys = "yst-supp", mod = "STORE_CONDITION")
    private String storeCondition;
    @ApiModelProperty("存储条件名称")
    private String storeConditionName;
    /**
     *
     */
    @ApiModelProperty("es1")
    private String es1;


    /**
     * es2
     */
    @ApiModelProperty("es2")
    private String es2;

    /**
     * es3
     */
    @ApiModelProperty("es3")
    private String es3;

    /**
     * es4
     */
    @ApiModelProperty("es4")
    private String es4;


    /**
     * es5
     */
    @ApiModelProperty("es5")
    private String es5;

    /**
     * es6
     */
    @ApiModelProperty("es6")
    private String es6;

    /**
     * es7
     */
    @ApiModelProperty("es7")
    private String es7;


    /**
     * es8
     */
    @ApiModelProperty("es8")
    private String es8;


    /**
     * es9
     */
    @ApiModelProperty("es9")
    private String es9;


    /**
     * es10
     */
    @ApiModelProperty("es10")
    private String es10;
    // ----------------------------------------- 2022-04-28 -----------------------


    @ApiModelProperty("是否第三方入驻")
    private String cat;

    @ApiModelProperty("是否有售后拆分件")
    private String cat2;

    /**
     * 商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE
     */
    @ApiModelProperty(value = "商品供给来源 [UDC]yst-supp:ITEM_SUPPLY_SOURCE")
    @SysCode(sys = "yst-supp", mod = "ITEM_SUPPLY_SOURCE")
    private String itemSupplySource;
    @ApiModelProperty("商品供给来源名称")
    private String itemSupplySourceName;

    /**
     * 最小起定量
     */
    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    /**
     * 商品规格2(1单规格 0多规格)
     */
    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    /**
     * 采购交期(天)
     */
    @ApiModelProperty(value = "采购交期(天)")
    private Integer purDelivPeriod;

    /**
     * 税收分类码 [UDC]yst-supp:TAX_CLASS_CODE
     */
    @ApiModelProperty(value = "税收分类码 [UDC]yst-supp:TAX_CLASS_CODE")
    @SysCode(sys = "yst-supp", mod = "TAX_CLASS_CODE")
    private String taxType;
    @ApiModelProperty("税收分类码名称")
    private String taxTypeName;


    /**
     * 标准供应价
     */
    @ApiModelProperty(value = "标准供应价")
    private BigDecimal price;

    /**
     * 商品类别码3 [UDC]yst-supp:ITEM_CAT3
     */
    @ApiModelProperty(value = "商品类别码3 [UDC]yst-supp:ITEM_CAT3")
    @SysCode(sys = "yst-supp", mod = "ITEM_CAT3")
    private String cat3;
    private String cat3Name;

    /**
     * 采购含税价
     */
    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    /**
     * 销售含税价
     */
    @ApiModelProperty(value = "销售含税价")
    private BigDecimal price9;

    @ApiModelProperty(value = "保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "外部系统标识")
    private String outSysKey;

    @ApiModelProperty(value = "外部系统skuId")
    private String outSysSkuId;

    @ApiModelProperty(value = "中包装计量单位转换系数")
    private BigDecimal uomRatio3;

    @ApiModelProperty(value = "大包装计量单位转换系数")
    private BigDecimal uomRatio4;

    @ApiModelProperty(value = "是否管理库存")
    private Boolean manageInvFlag;

    @ApiModelProperty(value = "物流仓默认功能区类型")
    private String logisticsWhDeter2Type;

    @ApiModelProperty(value = "门店仓默认功能区类型")
    private String storeWhDeter2Type;
}
