package com.elitesland.support.provider.org.dto;

import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgQualifyReviewRpcDTO extends CustomFieldBaseModelVo implements Serializable {

    private static final long serialVersionUID = -4556831321181172117L;

    @ApiModelProperty("id")
    private Long id;
    @ApiModelProperty("来源编码")
    private String origCode;
    @ApiModelProperty(value = "临时编码（保存没有提交审核的编码）")
    private String codeTemp;
    @ApiModelProperty("编码")
    private String code;
    @ApiModelProperty("名称")
    private String name;
    // 或简洁版
    @ApiModelProperty("发证机关")
    private String issuer;
    /**
     * 文审编码
     */
    @ApiModelProperty(value = "文审清单编码")
    private String docReviewCode;
    /**
     * 文审清单名称
     */
    @ApiModelProperty(value = "文审清单名称")
    private String docReviewName;
    /**
     * 文审编码
     */
    @ApiModelProperty(value = "文审清单类型")
    private String docReviewType;
    /**
     * 文审清单类型名称
     */
    @ApiModelProperty(value = "文审清单类型名称")
    private String docReviewTypeName;
    /**
     * 是否必传
     */
    @ApiModelProperty(value = "是否必传")
    private Boolean docReviewNeedUpload;

    @ApiModelProperty(value = "统一社会信息代码")
    private String uniCertNo;

    @ApiModelProperty(value = "法定代表人")
    private String legalPerson;

    @ApiModelProperty(value = "发证日期")
    private LocalDateTime issueDate;

    @ApiModelProperty(value = "经营场所")
    private String businessPlace;
    /**
     * 证件编码
     */
    @ApiModelProperty(value = "证件编码")
    private String qualifyNo;

    @ApiModelProperty("是否强控")
    private String strongControl;
    @ApiModelProperty("是否强控")
    private List<String> strongControlList;
    @ApiModelProperty("是否强控")
    private List<String> strongControlListName;

    @ApiModelProperty("是否强控")
    private List<OrgCodeNameVO> orgCodeNameVOList;
    /**
     * 生效日期
     */
    @ApiModelProperty(value = "生效日期")
    private LocalDateTime validFrom;

    /**
     * 失效日期
     */
    @ApiModelProperty(value = "失效日期")
    private LocalDateTime validTo;


    /**
     * 数据来源
     */
    @ApiModelProperty(value = "数据来源")
    private String dataSource;
    /**
     * 是否有效
     */
    @ApiModelProperty(value = "状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String qualifyStatus;
    /**
     * 是否有效
     */
    @ApiModelProperty(value = "状态 [UDC]COM:STATUS_ACTIVEORNO")
    private String qualifyStatusName;
    @ApiModelProperty("经营范围强控")
    private Boolean busEnable;
    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String remark;
    @ApiModelProperty("附件列表")
    private List<OrgQualifyReviewDRpcDTO> orgQualifyReviewDVOList;
}
