package com.elitesland.support.provider.mq;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.mq.MessageQueueTemplate;
import com.elitesland.support.provider.Application;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SyncMqSender {

    private static MessageQueueTemplate messageQueueTemplate;

    static {
        messageQueueTemplate = SpringContextHolder.getBean(MessageQueueTemplate.class);
    }

    public static void send(Long entityId, String entityKey, String entityType, String outSysType) {
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                messageQueueTemplate.publishMessage(Application.NAME, entityType + "__" + outSysType, new SyncMqMessage(entityId, entityKey, entityType, outSysType));
            }
        });
    }
    public static void send(String entityType, String outSysType, String data) {
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                messageQueueTemplate.publishMessage(Application.NAME, entityType + "__" + outSysType, new SyncMqMessage(entityType, outSysType,data));
            }
        });
    }

}
