package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2024/06/26
 * @Version 1.0
 * @Content:
 */
@Data
public class ItmItemScpBaseRpcDTO implements Serializable {
    private static final long serialVersionUID = 1841189813329011798L;

    @ApiModelProperty("商品SKU的ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("商品SKU的编码")
    private String itemCode;

    @ApiModelProperty("商品SKU的名称")
    private String itemName;

    @ApiModelProperty("spuId")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long spuId;

    @ApiModelProperty("SPU编号")
    private String spuCode;

    @ApiModelProperty("SPU名称")
    private String spuName;

    @ApiModelProperty("基本计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("辅助计量单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom2;
    private String uom2Name;

    @ApiModelProperty("商品SKU条码")
    private String barCode;

    @ApiModelProperty("规格型号")
    private String spec;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("商品类型 [UDC]ITM:ITEM_TYPE")
    @SysCode(sys = "yst-supp", mod = "ITEM_TYPE")
    private String itemType;
    private String itemTypeName;

    @ApiModelProperty("品牌")
    private String brand;
    @ApiModelProperty("品牌名称")
    private String brandName;

    @ApiModelProperty(value = "产地")
    @SysCode(sys = "yst-supp", mod = "ORIGIN")
    private String origin;
    private String originName;

    @ApiModelProperty(value = "商品规格2(1单规格 0多规格)")
    private String itemAttr2;

    @ApiModelProperty("品类(SPU)编号")
    private String itemCateCode;

    @ApiModelProperty("品类名称")
    private String itemCateName;

    @ApiModelProperty("品类(SPU)全路径名称")
    private List<String> itemCatePathName;

    @ApiModelProperty("品类(SPU)全称")
    private String itemCateFullName;

    @ApiModelProperty(name = "详细描述")
    private String itemDescribe;

    @ApiModelProperty(value = "别名")
    private String anotherName;

    @ApiModelProperty(value = "商品规格(JSON格式)")
    private String itemAttr;
    @ApiModelProperty(value = "商品规格名称(多个;分隔)")
    private String itemAttrName;

    @ApiModelProperty("单位转换系数")
    private BigDecimal uomRatio2;

    @ApiModelProperty("有效位数")
    private Integer decimalPlaces;

    @ApiModelProperty(value = "SPU商品图片")
    private List<ItmItemAttachmentRpcDTO> spuAttchmentList;

    @ApiModelProperty(value = "SKU商品图片")
    private List<ItmItemAttachmentRpcDTO> skuAttchmentList;

    @ApiModelProperty("领用单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String receiveUom;
    private String receiveUomName;

    @ApiModelProperty(value = "领用单位转换系数")
    private BigDecimal receiveUomRatio;

    @ApiModelProperty(value = "出成率")
    private BigDecimal yield;

    @ApiModelProperty("半成品耗用方式")
    @SysCode(sys = "yst-supp", mod = "SEMI_USAGE_TYPE")
    private String semiProdConsMode;
    private String semiProdConsModeName;

    @ApiModelProperty("出成数量")
    private Integer outputQty;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    @ApiModelProperty(value = "价格")
    private BigDecimal price;

    @ApiModelProperty("子件父id")
    private Long bomPid;

    @ApiModelProperty("子件数量")
    private BigDecimal bomQty;

    @ApiModelProperty(value = "子件")
    private List<ItmItemScpBaseRpcDTO> subItems;

}
