package com.elitesland.support.provider.org.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.org.dto.*;
import com.elitesland.support.provider.org.param.*;
import com.elitesland.support.provider.thaliItem.dto.StoreThaliItemRpcDTO;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@FeignClient(name = Application.NAME, path = Application.PATH + OrgStoreRpcService.PATH)
@Validated
public interface OrgStoreRpcService {
    String PATH = "/orgStoreRpc";

    @GetMapping("/{id}")
    OrgStoreDetailRpcDTO get(@PathVariable("id") Long id);

    @GetMapping("/getByCode")
    OrgStoreDetailRpcDTO getByCode(@RequestParam("storeCode") String storeCode);

    @PostMapping("/storeWh/codes")
    ApiResult<List<OrgStoreWhDTO>> listWhByCode(@RequestBody List<String> storeCodes);

    @PostMapping("/queryByIds")
    List<OrgStoreDetailRpcDTO> queryByIds(@RequestBody List<Long> ids);

    @PostMapping("/queryByStoreCodes")
    List<OrgStoreDetailRpcDTO> queryByStoreCodes(@RequestBody List<String> storeCodes);


    @PostMapping("/appSearch")
    List<OrgStoreRpcDTO> appSearch(@RequestBody OrgStoreRpcParam param);

    @PostMapping("/pageStoreQuery")
    PagingVO<OrgStoreRpcDTO> rpcStoreQuery(@RequestBody OrgStoreRpcParam param);

    /**
     * 查询门店基础信息
     *
     * @param baseRpcParam
     * @return
     */
    @PostMapping("/findOrgStoreBaseByParam")
    ApiResult<List<OrgStoreBaseRpcDTO>> findOrgStoreBaseByParam(@RequestBody OrgStoreBaseRpcParam baseRpcParam);


    /**
     * 根据门店编码查询联系人
     *
     * @param storeCode
     * @return
     */
    @GetMapping("/findContactByStoreCode")
    List<OrgContactRpcDTO> findContactByStoreCode(@RequestParam("storeCode") String storeCode);

    /**
     * 门店批量更新接口
     * @ paramList<OrgStoreSaveRpcParam> params
     * @return
     */
    @PostMapping("/batchUpdate")
    ApiResult<String> batchUpdate(@RequestBody List<OrgStoreSaveRpcParam> params);

    /**
     * 农小锅门店编码存在更新门店列表/不存在新增门店申请列表
     * @ paramList<OrgStoreSaveRpcParam> params
     * @return
     */
    @PostMapping("/orgStoreUpdateOrStoreApplyAdd")
    ApiResult<String> orgStoreUpdateOrStoreApplyAdd(@RequestBody OrgStoreApproveDtoParam params);
    /**
     * 根据仓库编码获取门店信息
     * @return
     */
    @GetMapping("/getOrgStoreByWhCode")
    ApiResult<OrgStoreBaseRpcDTO> getOrgStoreByWhCode(@RequestParam("whCode") String whCode);
    @PostMapping("/queryStoreCustIds")
    ApiResult<List<String>> queryStoreCustIds(@RequestBody OrgStoreBaseRpcParam baseRpcParam);
    @PostMapping("/pageQueryStoreCodes")
    ApiResult<PagingVO<String>> pageQueryStoreCodes(@RequestBody OrgStoreRpcParam param);
    @PostMapping("/syncStoreThaliItem")
    ApiResult<String> syncStoreThaliItem(@RequestBody List<StoreThaliItemRpcDTO> storeThaliItemRpcDTOS);
    @PostMapping("/queryStoreWhCodes")
    ApiResult<List<String>> queryStoreWhCodes(@RequestBody OrgStoreBaseRpcParam baseRpcParam);

    @GetMapping("/findBankByStoreCode")
    List<OrgBankRpcDTO> findBankByStoreCode(@RequestParam("storeCode") String storeCode);

    @PostMapping("/querydetailByStoreCodes")
    ApiResult<List<OrgStoreDetailRpcDTO>> querydetailByStoreCodes(@RequestBody List<String> storeCodes);
    @PostMapping("/queryDetaiByWhCodes")
    ApiResult<List<OrgStoreBaseRpcDTO>> queryDetaiByWhCodes(@RequestBody List<String> whCodes);

    @PostMapping("/pageBaseStore")
    PagingVO<OrgStoreBaseRpcDTO> pageBaseStore(@RequestBody OrgStoreBasePageRpcParam param);

    @PostMapping("/countBaseStore")
    ApiResult<Long> countBaseStoreByParam(@RequestBody OrgStoreBasePageRpcParam param);
}
