package com.elitesland.support.provider.flexField.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldAbstractVo;
import com.elitescloud.boot.core.support.customfield.common.CustomFieldBaseModelVo;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.constant.RedisKeyConstant;
import com.elitesland.support.provider.flexField.dto.FlexFieldShowNamesRpcDTO;
import com.elitesland.support.provider.flexField.dto.FlexFieldStructDRpcDTO;
import com.elitesland.support.provider.flexField.dto.FlexFieldValueRpcDTO;
import com.elitesland.support.provider.flexField.dto.ObjectFlexFieldValueRpcDTO;
import com.elitesland.support.provider.flexField.param.*;
import io.reactivex.rxjava3.functions.Function;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
@Slf4j
@Service
public class FlexFieldUtilServiceImpl implements FlexFieldUtilService{
    @Autowired
    private FlexFieldRpcService flexFieldRpcService;
    @Autowired
    private  RedisUtils redisUtils;
    @Override
    public Map<String,String> handFlexFieldValueFeference(String flexFieldCode, Map<String,String> flexFieldWhereClauseMap, Map<String,String> extensionInfo){
       log.info("处理值传递，参数，flexFieldCode：{}，flexFieldWhereClauseMap：{}，extensionInfo：{}",flexFieldCode, JSON.toJSONString(flexFieldWhereClauseMap),JSON.toJSONString(extensionInfo));
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("处理值传递引用，弹性域编码为空");
        }
        Map<String, String> newExtensionInfo = new HashMap<>();
        if(extensionInfo==null){
            newExtensionInfo = new HashMap<>();
        }else{
            newExtensionInfo = new HashMap<>(extensionInfo);
        }
        FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam=new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList  =flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("处理值传递，弹性域：{}，rpc查询字段配置结果：{}",flexFieldCode, JSON.toJSONString(flexFieldStructDList));
        if(CollectionUtils.isNotEmpty(flexFieldStructDList.getData())){
            //找出值传递字段
            List<FlexFieldStructDRpcDTO> referFlexFields = flexFieldStructDList.getData().stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(referFlexFields)){
                List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams= referFlexFields.stream().map(v -> {
                    FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                    flexFieldValueQueryRpcParam.setFlexField(v.getFlexField());
                    flexFieldValueQueryRpcParam.setWhereClause(flexFieldWhereClauseMap.get(v.getFlexField()));
                    return flexFieldValueQueryRpcParam;
                }).collect(Collectors.toList());
                FlexFieldValueQueryRpcNewParam flexFieldValueQueryRpcNewParam = new FlexFieldValueQueryRpcNewParam();
                flexFieldValueQueryRpcNewParam.setFlexFieldCode(flexFieldCode);
                flexFieldValueQueryRpcNewParam.setFlexFieldValueQueryRpcParams(flexFieldValueQueryRpcParams);
                ApiResult<Map<String, FlexFieldValueRpcDTO>> apiResult=flexFieldRpcService.queryFlexFieldValuesNew(flexFieldValueQueryRpcNewParam);
                Map<String, FlexFieldValueRpcDTO> flexFieldValueMap = apiResult.getData();
                if(flexFieldValueMap!=null&&!flexFieldValueMap.isEmpty()){
                    for (Map.Entry<String, FlexFieldValueRpcDTO> flexFieldValueEntry : flexFieldValueMap.entrySet()) {
                        newExtensionInfo.put(flexFieldValueEntry.getKey(), flexFieldValueEntry.getValue() != null ? flexFieldValueEntry.getValue().getFlexFieldValue().toString() : "");
                    }
                }
            }
        }
        if(newExtensionInfo.isEmpty()){
            return null;
        }
        extensionInfo = newExtensionInfo;
        return newExtensionInfo;
    }

    @Override
    public Map<String, String> handFlexFieldValueFeference(String flexFieldCode, Object obj, Map<String, String> extensionInfo) {
        log.info("处理值传递，参数，flexFieldCode：{}，obj：{}，extensionInfo：{}",flexFieldCode, JSON.toJSONString(obj),JSON.toJSONString(extensionInfo));
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("处理值传递引用，弹性域编码为空");
        }
        if(obj==null){
            return extensionInfo;
        }
        if (extensionInfo==null) {
            extensionInfo = new HashMap<>();
        }
        Map<String, Object> objectMap = BeanUtil.beanToMap(obj);
        FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam=new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList  =flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("处理值传递，弹性域：{}，rpc查询字段配置结果：{}",flexFieldCode, JSON.toJSONString(flexFieldStructDList));
        if(CollectionUtils.isNotEmpty(flexFieldStructDList.getData())){
            //找出值传递字段
            List<FlexFieldStructDRpcDTO> referFlexFields = flexFieldStructDList.getData().stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(referFlexFields)){
                List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams= referFlexFields.stream().map(v -> {
                    FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                    flexFieldValueQueryRpcParam.setFlexField(v.getFlexField());
                    String referSqlCondition = v.getReferSqlCondition();
                    if(obj!=null){
                        referSqlCondition = handleSqlCondition(referSqlCondition, objectMap);
                    }
                    flexFieldValueQueryRpcParam.setWhereClause(referSqlCondition);
                    return flexFieldValueQueryRpcParam;
                }).collect(Collectors.toList());
                FlexFieldValueQueryRpcNewParam flexFieldValueQueryRpcNewParam = new FlexFieldValueQueryRpcNewParam();
                flexFieldValueQueryRpcNewParam.setFlexFieldCode(flexFieldCode);
                flexFieldValueQueryRpcNewParam.setFlexFieldValueQueryRpcParams(flexFieldValueQueryRpcParams);
                ApiResult<Map<String, FlexFieldValueRpcDTO>> apiResult=flexFieldRpcService.queryFlexFieldValuesNew(flexFieldValueQueryRpcNewParam);
                Map<String, FlexFieldValueRpcDTO> flexFieldValueMap = apiResult.getData();
                if(flexFieldValueMap!=null&&!flexFieldValueMap.isEmpty()){
                    for (Map.Entry<String, FlexFieldValueRpcDTO> flexFieldValueEntry : flexFieldValueMap.entrySet()) {
                        extensionInfo.put(flexFieldValueEntry.getKey(), flexFieldValueEntry.getValue() != null ? flexFieldValueEntry.getValue().getFlexFieldValue().toString() : "");
                    }
                }
            }
        }
        if(extensionInfo.isEmpty()){
            return null;
        }
        return extensionInfo;
    }

    @Override
    public Map<String, String> handFlexFieldValueFeference(String flexFieldCode, Object obj) {
        log.info("处理值传递，参数，flexFieldCode：{}，obj：{}",flexFieldCode, JSON.toJSONString(obj));
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("处理值传递引用，弹性域编码为空");
        }
        Object o = redisUtils.get(RedisKeyConstant.FLEX_FIELD_STATUS_PREFIX + flexFieldCode);
        if(!"ACTIVE".equals(o)){
            //禁用
            log.info("处理值传递，当前弹性域未启用，flexFieldCode：{}",flexFieldCode);
            return null;
        }
        if(obj==null){
            return null;
        }
        Map<String, Object> objectMap = BeanUtil.beanToMap(obj);
        Map<String,String> extensionInfo=null;
        if(!objectMap.containsKey("extensionInfo")){
            throw new BusinessException("处理值传递引用，目标对象不包含extensionInfo属性");
        }
        extensionInfo = (Map<String, String>) objectMap.get("extensionInfo");
        if(extensionInfo==null){
            extensionInfo=new HashMap<>();
            BeanUtil.setFieldValue(obj, "extensionInfo", extensionInfo);
        }

        FlexFieldReferenceValueQueryRpcParam flexFieldReferenceValueQueryRpcParam = new FlexFieldReferenceValueQueryRpcParam();
        flexFieldReferenceValueQueryRpcParam.setArg(objectMap);
        flexFieldReferenceValueQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<Map<String, String>> result = flexFieldRpcService.queryFlexFieldFeferenceValueNew(flexFieldReferenceValueQueryRpcParam);
        if(result.isSuccess()&&result.getData()!=null&&!result.getData().isEmpty()){
            extensionInfo.putAll(result.getData());
        }
        /*FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam=new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList  =flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("处理值传递，弹性域：{}，rpc查询字段配置结果：{}",flexFieldCode, JSON.toJSONString(flexFieldStructDList));
        if(CollectionUtils.isNotEmpty(flexFieldStructDList.getData())){
            //找出值传递字段
            List<FlexFieldStructDRpcDTO> referFlexFields = flexFieldStructDList.getData().stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(referFlexFields)){
                FlexFieldValueQueryRpcNewParam flexFieldValueQueryRpcNewParam = new FlexFieldValueQueryRpcNewParam();
                flexFieldValueQueryRpcNewParam.setFlexFieldCode(flexFieldCode);
                List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams= referFlexFields.stream().map(v -> {
                    FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                    flexFieldValueQueryRpcParam.setFlexField(v.getFlexField());
                    String referSqlCondition = v.getReferSqlCondition();
                    if(obj!=null){
                        referSqlCondition = handleSqlCondition(referSqlCondition, objectMap);
                    }
                    flexFieldValueQueryRpcParam.setWhereClause(referSqlCondition);
                    return flexFieldValueQueryRpcParam;
                }).collect(Collectors.toList());
                flexFieldValueQueryRpcNewParam.setFlexFieldValueQueryRpcParams(flexFieldValueQueryRpcParams);
                ApiResult<Map<String, FlexFieldValueRpcDTO>> apiResult=flexFieldRpcService.queryFlexFieldValuesNew(flexFieldValueQueryRpcNewParam);
                log.info("处理值传递，弹性域：{}，rpc获取字段值结果：{}",flexFieldCode, JSON.toJSONString(apiResult));
                List<String> referFlexFieldCodes = referFlexFields.stream().map(v -> v.getFlexField()).collect(Collectors.toList());
                Map<String, FlexFieldValueRpcDTO> flexFieldValueMap = apiResult.getData();
                if(flexFieldValueMap==null){
                    flexFieldValueMap = new HashMap<>();
                }
                for (String referFlexFieldCode : referFlexFieldCodes) {
                    FlexFieldValueRpcDTO flexFieldValueRpcDTO = flexFieldValueMap.get(referFlexFieldCode);
                    if(flexFieldValueRpcDTO!=null&&flexFieldValueRpcDTO.getFlexFieldValue()!=null){
                        extensionInfo.put(referFlexFieldCode,flexFieldValueRpcDTO.getFlexFieldValue().toString());
                    }else{
                        extensionInfo.put(referFlexFieldCode,"");
                    }
                }
            }
        }*/
        return extensionInfo;
    }

    @Override
    public <T> void handFlexFieldValueFeferenceList(String flexFieldCode, List<T> objs) {
        log.info("处理值传递，参数，flexFieldCode：{}，obj：{}",flexFieldCode, JSON.toJSONString(objs));
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("处理值传递引用，弹性域编码为空");
        }
        if(CollectionUtils.isEmpty(objs)){
            return ;
        }
        Object flexFieldState = redisUtils.get(RedisKeyConstant.FLEX_FIELD_STATUS_PREFIX + flexFieldCode);
        if(!"ACTIVE".equals(flexFieldState)){
            //禁用
            log.info("处理值传递，当前弹性域未启用，flexFieldCode：{}",flexFieldCode);
            return ;
        }
        //查询配置
        FlexFieldStructDQueryRpcParam flexFieldStructDQueryRpcParam=new FlexFieldStructDQueryRpcParam();
        flexFieldStructDQueryRpcParam.setFlexFieldCode(flexFieldCode);
        ApiResult<List<FlexFieldStructDRpcDTO>> flexFieldStructDList  =flexFieldRpcService.queryFlexFieldStructDS(flexFieldStructDQueryRpcParam);
        log.info("处理值传递，弹性域：{}，rpc查询字段配置结果：{}",flexFieldCode, JSON.toJSONString(flexFieldStructDList));
        if(CollectionUtils.isNotEmpty(flexFieldStructDList.getData())){
            //找出值传递字段
            List<FlexFieldStructDRpcDTO> referFlexFields = flexFieldStructDList.getData().stream().filter(v -> "FLEX_FIELD".equals(v.getSourceType())).collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(referFlexFields)){
                Map<Long, Map<String, String>> objExtensionInfoMap = new HashMap<>();
                ListFlexFieldValueQueryRpcParam listFlexFieldValueQueryRpcParam = new ListFlexFieldValueQueryRpcParam();
                listFlexFieldValueQueryRpcParam.setFlexFieldCode(flexFieldCode);
                List<ObjectFlexFieldValueQueryRpcParam> objectFlexFieldValueQueryRpcParams = new ArrayList<>();
                listFlexFieldValueQueryRpcParam.setParams(objectFlexFieldValueQueryRpcParams);
                List<String> referFlexFieldCodes = referFlexFields.stream().map(v -> v.getFlexField()).collect(Collectors.toList());
                for (int i = 0; i < objs.size(); i++) {
                    Object obj = objs.get(i);
                    Map<String, Object> objectMap = BeanUtil.beanToMap(obj);
                    Map<String, String> extensionInfo = null;
                    if (objectMap.containsKey("extensionInfo")) {
                        extensionInfo = (Map<String, String>) objectMap.get("extensionInfo");
                    }
                    if (extensionInfo == null) {
                        extensionInfo = new HashMap<>();
                        BeanUtil.setFieldValue(obj, "extensionInfo", extensionInfo);
                    }
                    Long idValue = Long.valueOf(i);
                    objExtensionInfoMap.put(idValue, extensionInfo);
                    ObjectFlexFieldValueQueryRpcParam objectFlexFieldValueQueryRpcParam = new ObjectFlexFieldValueQueryRpcParam();
                    objectFlexFieldValueQueryRpcParam.setId(idValue);
                    List<FlexFieldValueQueryRpcParam> flexFieldValueQueryRpcParams = new ArrayList<>();
                    for (FlexFieldStructDRpcDTO referFlexField : referFlexFields) {
                        FlexFieldValueQueryRpcParam flexFieldValueQueryRpcParam = new FlexFieldValueQueryRpcParam();
                        flexFieldValueQueryRpcParam.setFlexField(referFlexField.getFlexField());
                        String referSqlCondition = referFlexField.getReferSqlCondition();
                        if (obj != null) {
                            referSqlCondition = handleSqlCondition(referSqlCondition, objectMap);
                        }
                        flexFieldValueQueryRpcParam.setWhereClause(referSqlCondition);
                        flexFieldValueQueryRpcParams.add(flexFieldValueQueryRpcParam);
                    }
                    objectFlexFieldValueQueryRpcParam.setParams(flexFieldValueQueryRpcParams);
                    objectFlexFieldValueQueryRpcParams.add(objectFlexFieldValueQueryRpcParam);
                }
                ApiResult<List<ObjectFlexFieldValueRpcDTO>> apiResult = flexFieldRpcService.queryFlexFieldValuesList(listFlexFieldValueQueryRpcParam);
                List<ObjectFlexFieldValueRpcDTO> objectFlexFieldValueRpcDTOS = apiResult.getData();
                if(CollectionUtils.isNotEmpty(objectFlexFieldValueRpcDTOS)){
                    //赋值
                    for (ObjectFlexFieldValueRpcDTO objectFlexFieldValueRpcDTO : objectFlexFieldValueRpcDTOS) {
                        Map<String, String> extensionInfo = objExtensionInfoMap.get(objectFlexFieldValueRpcDTO.getId());
                        Map<String, FlexFieldValueRpcDTO> flexFieldValueMap = new HashMap<>();
                        if(CollectionUtils.isNotEmpty(objectFlexFieldValueRpcDTO.getFlexFieldValueRpcDTOS())){
                            flexFieldValueMap= objectFlexFieldValueRpcDTO.getFlexFieldValueRpcDTOS().stream().collect(Collectors.toMap(v -> v.getFlexField(), v -> v, (o, n) -> n));;
                        }
                        for (String referFlexFieldCode : referFlexFieldCodes) {
                            FlexFieldValueRpcDTO flexFieldValueRpcDTO = flexFieldValueMap.get(referFlexFieldCode);
                            if(flexFieldValueRpcDTO!=null&&flexFieldValueRpcDTO.getFlexFieldValue()!=null){
                                extensionInfo.put(referFlexFieldCode, flexFieldValueRpcDTO.getFlexFieldValue().toString());
                            }else{
                                extensionInfo.put(referFlexFieldCode, "");
                            }
                        }
                    }
                }
            }
        }
        return ;
    }

    @Override
    public void handleFlexFieldShowName(String flexFieldCode, List<? extends CustomFieldAbstractVo> records, Function<Object,Long> idGenerator){
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("翻译弹性域显示名称异常，弹性域编码为空");
        }
        if(CollectionUtils.isEmpty(records)){
            return ;
        }
        if(CollectionUtils.isNotEmpty(records)){
            FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam = new FlexFieldShowNamesQueryRpcParam();
            flexFieldShowNameQueryRpcParam.setFlexFieldCode(flexFieldCode);
            List<FlexFieldShowNamesRpcDTO> flexFieldShowNamesRpcDTOList = records.stream().map(v -> {
                FlexFieldShowNamesRpcDTO flexFieldShowNamesRpcDTO = new FlexFieldShowNamesRpcDTO();
                try {

                    flexFieldShowNamesRpcDTO.setId(v.getId());
                } catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                flexFieldShowNamesRpcDTO.setExtensionInfo(v.getExtensionInfo());
                return flexFieldShowNamesRpcDTO;
            }).collect(Collectors.toList());
            flexFieldShowNameQueryRpcParam.setFlexFieldShowNamesRpcDTOList(flexFieldShowNamesRpcDTOList);
            ApiResult<Map<Long, Map<String, String>>> flexFieldShowNames = flexFieldRpcService.queryFlexFieldShowNames(flexFieldShowNameQueryRpcParam);
            if(flexFieldShowNames.isSuccess()&&flexFieldShowNames.getData()!=null&&!flexFieldShowNames.getData().isEmpty()){
                records.stream().forEach(v->{
                    try {
                        v.setExtensionInfo(flexFieldShowNames.getData().get(v.getId()));
                    } catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }

    @Override
    public void handleFlexFieldShowName(String flexFieldCode, List<? extends CustomFieldAbstractVo> records) {
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("翻译弹性域显示名称异常，弹性域编码为空");
        }
        if(CollectionUtils.isEmpty(records)){
            return ;
        }
        if(CollectionUtils.isNotEmpty(records)){
            FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam = new FlexFieldShowNamesQueryRpcParam();
            flexFieldShowNameQueryRpcParam.setFlexFieldCode(flexFieldCode);
            List<FlexFieldShowNamesRpcDTO> flexFieldShowNamesRpcDTOList = records.stream().map(v -> {
                FlexFieldShowNamesRpcDTO flexFieldShowNamesRpcDTO = new FlexFieldShowNamesRpcDTO();
                try {

                    flexFieldShowNamesRpcDTO.setId(v.getId());
                } catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                flexFieldShowNamesRpcDTO.setExtensionInfo(v.getExtensionInfo());
                return flexFieldShowNamesRpcDTO;
            }).collect(Collectors.toList());
            flexFieldShowNameQueryRpcParam.setFlexFieldShowNamesRpcDTOList(flexFieldShowNamesRpcDTOList);
            ApiResult<Map<Long, Map<String, String>>> flexFieldShowNames = flexFieldRpcService.queryFlexFieldShowNames(flexFieldShowNameQueryRpcParam);
            if(flexFieldShowNames.isSuccess()&&flexFieldShowNames.getData()!=null&&!flexFieldShowNames.getData().isEmpty()){
                records.stream().forEach(v->{
                    try {
                        v.setExtensionInfo(flexFieldShowNames.getData().get(v.getId()));
                    } catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }


    @Override
    public <T extends CustomFieldAbstractVo> void handleSingleFlexFieldShowName(String flexFieldCode, T record) {
        if(record==null){
            return ;
        }
        List<T> records = new ArrayList<>();
        records.add(record);
        this.handleFlexFieldShowName(flexFieldCode,records);
    }

    @Override
    public <T extends CustomFieldBaseModelVo> void handleFlexFieldShowNameForVO(String flexFieldCode, List<T> records) {
        if(StringUtils.isBlank(flexFieldCode)){
            throw new BusinessException("翻译弹性域显示名称异常，弹性域编码为空");
        }
        if(CollectionUtils.isEmpty(records)){
            return ;
        }
        Object o = redisUtils.get(RedisKeyConstant.FLEX_FIELD_STATUS_PREFIX + flexFieldCode);
        if(!"ACTIVE".equals(o)){
            //禁用
            log.info("处理值传递，当前弹性域未启用，flexFieldCode：{}",flexFieldCode);
            return ;
        }
        if(CollectionUtils.isNotEmpty(records)){
            FlexFieldShowNamesQueryRpcParam flexFieldShowNameQueryRpcParam = new FlexFieldShowNamesQueryRpcParam();
            flexFieldShowNameQueryRpcParam.setFlexFieldCode(flexFieldCode);
            List<FlexFieldShowNamesRpcDTO> flexFieldShowNamesRpcDTOList = records.stream().map(v -> {
                FlexFieldShowNamesRpcDTO flexFieldShowNamesRpcDTO = new FlexFieldShowNamesRpcDTO();
                try {

                    flexFieldShowNamesRpcDTO.setId(v.getId());
                } catch (Throwable e) {
                    throw new RuntimeException(e);
                }
                flexFieldShowNamesRpcDTO.setExtensionInfo(v.getExtensionInfo());
                return flexFieldShowNamesRpcDTO;
            }).collect(Collectors.toList());
            flexFieldShowNameQueryRpcParam.setFlexFieldShowNamesRpcDTOList(flexFieldShowNamesRpcDTOList);
            ApiResult<Map<Long, Map<String, String>>> flexFieldShowNames = flexFieldRpcService.queryFlexFieldShowNames(flexFieldShowNameQueryRpcParam);
            if(flexFieldShowNames.isSuccess()&&flexFieldShowNames.getData()!=null&&!flexFieldShowNames.getData().isEmpty()){
                records.stream().forEach(v->{
                    try {
                        v.setExtensionInfo(flexFieldShowNames.getData().get(v.getId()));
                    } catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
    }
    @Override
    public <T extends CustomFieldBaseModelVo> void handleSingleFlexFieldShowNameForVO(String flexFieldCode, T record) {
        if(record==null){
            return ;
        }
        List<T> records = new ArrayList<>();
        records.add(record);
        this.handleFlexFieldShowNameForVO(flexFieldCode,records);
    }

    public String handleSqlCondition(String src,Map<String,Object> argsMap){
        if (StringUtils.isBlank(src)) {
            return src;
        }
        if(argsMap==null||argsMap.isEmpty()){
            return src;
        }
        String reg = "@[a-z|A-Z|\\d]+_?[a-z|A-Z|\\d]*@";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(src);
        while (matcher.find()) {
            String group = matcher.group();
            String[] split = group.split("@");
            if(StringUtils.isBlank(split[1])){
                return src;
            }
            Object argObj = argsMap.get(split[1]);
            if(argObj==null){
                return src;
            }
            if (StringUtils.isBlank(argObj.toString())) {
                return src;
            }
            src = src.replace(group, argObj.toString());
        }
      return src;
    }
}
