package com.elitesland.support.provider.org.param.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
@ApiModel("公司信息")
public class OrgOuOpenApiDTO implements Serializable {
    private static final long serialVersionUID = 8875555553315148351L;
    @ApiModelProperty(value = "唯一id")
    private Long id;
    @ApiModelProperty(value = "公司编码")
    private String ouCode;

    @ApiModelProperty(value = "公司名称")
    private String ouName;

    @ApiModelProperty(value = "简称")
    private String ouAbbr;

    @ApiModelProperty(value = "上级组织编码")
    private String pcode;

    @ApiModelProperty(value = "公司类型",
            notes = "1、company：公司；2、company_sub：分公司；3、group：集团")
    private String ouType;

    @ApiModelProperty(value = "公司归类",
            notes = "1、INNER：集团内公司；2、OUTER：外部公司")
    private String ouType2;

    @ApiModelProperty(value = "公司状态",
            notes = "1、ACTIVE：正常；2、CLOSED：已停用；3、DRAFT：草稿")
    private String ouStatus;

    @ApiModelProperty(value = "统一社会信用码")
    private String uniCertNo;

    @ApiModelProperty(value = "本位币",
            notes = "1、CNY：人民币；2、USD：美元；3、JPY：日元；4、HKD：港币；5、EUR：欧元；6、GBP：英镑；6、AUD：澳元")
    private String ouCurr;

    @ApiModelProperty(value = "纳税人类型")
    private String taxpayerType;

    @ApiModelProperty(value = "法人代表")
    private String reprName;

    @ApiModelProperty(value = "是否新建组织")
    private Boolean selectedCreateOu;

    @ApiModelProperty(value = "发票类型",
            notes = "1、VANA：增值税专票；2、VANNP：增值税普票；3、VANSP：电子增值税普票；4、VATN：农产品收购发票和农产品销售发票；5、VATS：无")
    private String invType;

    @ApiModelProperty(value = "开票抬头")
    private String invTitle;

    @ApiModelProperty(value = "税号")
    private String taxRegNo;

    @ApiModelProperty(value = "开票电话")
    private String invTel;

    @ApiModelProperty(value = "开票联系人电话")
    private String invPicPhone;

    @ApiModelProperty(value = "开票联系人")
    private String invPicName;

    @ApiModelProperty(value = "开票地址")
    private String invAddress;

    @ApiModelProperty(value = "开户银行")
    private String invBankName;

    @ApiModelProperty(value = "银行账号")
    private String invBankAcc;

    @ApiModelProperty(value = "地址信息")
    private List<OuAddress> ouAddressList;
    @ApiModelProperty(value = "账户信息")
    private List<OrgBankAccount> orgBankAccountList;
}
