package com.elitesland.support.provider.item.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
@ApiModel(value = "商品简要信息", description = "商品简要信息")
public class ItmItemSimpleRpcDTO implements Serializable {

    private static final long serialVersionUID = -8863745052232596865L;

    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("规格")
    private String spec;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("商品类型")
    private String itemType;

    @ApiModelProperty("商品分类编码")
    private String itemCateCode;

    @ApiModelProperty("分类名称")
    private String itemCateName;

    @ApiModelProperty("分类名称")
    private String itemCateFullName;

    @ApiModelProperty("品牌")
    private String brandName;

    @ApiModelProperty(value = "最小起定量")
    private BigDecimal moq;

    @ApiModelProperty(value = "采购含税价")
    private BigDecimal price8;

    @ApiModelProperty(value = "保留小数位")
    private Integer decimalPlaces;

    @ApiModelProperty("辅助单位")
    private String uom2;

    @ApiModelProperty(value = "单位转换率")
    private BigDecimal uomRatio2;
}
