package com.elitesland.support.provider.item.dto;

import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author Chris
 * @date 2021-04-27
 */
@Data
@ApiModel("菜品RPCDTO参数")
public class ThaliItemNewRpcDTO implements Serializable {

    @ApiModelProperty("ID")
    private Long id;

    @ApiModelProperty("菜品系统编码")
    private String thaliNo;

    @ApiModelProperty("菜品编码")
    private String thaliItemCode;

    @ApiModelProperty("菜品名称")
    private String thaliItemName;

    @ApiModelProperty("状态")
    @SysCode(sys = "yst-supp", mod = "THALI_STATUS")
    private String docStatus;
    private String docStatusName;

    @ApiModelProperty("菜品类型")
    @SysCode(sys = "yst-supp", mod = "THALI_TYPE")
    private String thaliType;
    private String thaliTypeName;

    @ApiModelProperty("菜品分类")
    @SysCode(sys = "yst-supp", mod = "THALI_CLS")
    private String thaliCls;
    private String thaliClsName;

    @ApiModelProperty("启用禁用状态")
    @SysCode(sys = "yst-supp", mod = "THALI_ITEM_STATUS")
    private String itemStatus;
    private String itemStatusName;

    @ApiModelProperty("菜品单位")
    @SysCode(sys = "yst-supp", mod = "UOM")
    private String uom;
    private String uomName;

    @ApiModelProperty("是否称重")
    private Boolean weightStatus;

    @ApiModelProperty("加工方式")
    @SysCode(sys = "yst-supp", mod = "MANU_TYPE")
    private String manuType;
    private String manuTypeName;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("套件信息")
    private List<ThaliItemDetailNewRpcDTO> thaliItemNewGroupList;

}
