package com.elitesland.support.provider.mq;

import com.elitescloud.boot.mq.common.BaseMessage;
import lombok.Data;

import java.io.Serializable;

@Data
public class SyncMqMessage extends BaseMessage implements Serializable {

    private Long entityId;

    private String entityKey;

    private String entityType;

    private String outSysType;

    private String businessKey;

    String data;

    @Override
    public String getBusinessKey() {
        return entityId.toString();
    }

    public SyncMqMessage() {}

    public SyncMqMessage(Long entityId, String entityKey, String entityType, String outSysType) {
        this.entityId = entityId;
        this.entityKey = entityKey;
        this.entityType = entityType;
        this.outSysType = outSysType;
        this.businessKey = entityKey + "@" + businessKey;
    }
    public SyncMqMessage(String entityType, String outSysType,String data) {
        this.entityType = entityType;
        this.outSysType = outSysType;
        this.businessKey = entityKey + "@" + businessKey;
        this.data = data;
    }
}
