package com.elitesland.support.provider.org.param;

import com.elitesland.support.provider.org.RpcBaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-10
 */
@Data
public class OrgAddrAddressSaveRpcParam extends RpcBaseModel implements Serializable,DataHash {

    private static final long serialVersionUID = 111978593690482018L;

    @ApiModelProperty("id")
    private Long id;

    /**
     * 地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE
     */
    @ApiModelProperty(value = "地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE", required = true)
    private String addressType;

    /**
     * 是否默认：1是，0否
     */
    @ApiModelProperty(value = "是否默认：1是，0否", required = true)
    private Boolean defaultFlag;

    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contPerson;

    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    private String mobile;

    /**
     * 电话
     */
    @ApiModelProperty(value = "电话")
    private String tel;

    /**
     * 传真
     */
    @ApiModelProperty(value = "传真")
    private String fax;

    /**
     * 电邮
     */
    @ApiModelProperty(value = "电邮")
    private String email;

    /**
     * 邮政编码
     */
    @ApiModelProperty(value = "邮政编码")
    private String zipCode;

    /**
     * 国家
     */
    @ApiModelProperty(value = "国家")
    private String country;

    /**
     * 省份(编号/ID)
     */
    @ApiModelProperty(value = "省份(编号/ID)")
    private String province;

    /**
     * 城市(编号/ID)
     */
    @ApiModelProperty(value = "城市(编号/ID)")
    private String city;

    /**
     * 区县(编号/ID)
     */
    @ApiModelProperty(value = "区县(编号/ID)")
    private String county;

    /**
     * 街道/乡镇(文本)
     */
    @ApiModelProperty(value = "街道/乡镇(文本)")
    private String street;

    /**
     * 详细地址
     */
    @ApiModelProperty(value = "详细地址")
    private String detailAddr;

    /**
     * 数据来源
     */
    @ApiModelProperty(value = "数据来源")
    private String dataSource;

    /**
     * 微信号
     */
    @ApiModelProperty("微信号")
    private String weChatNo;

    /**
     * qq号
     */
    @ApiModelProperty("qq号")
    private String qqNo;

    /**
     * ES1
     */
    @ApiModelProperty(value = "ES1")
    private String es1;

    /**
     * ES2
     */
    @ApiModelProperty(value = "ES2")
    private String es2;

    /**
     * ES3
     */
    @ApiModelProperty(value = "ES3")
    private String es3;

    /**
     * ES4
     */
    @ApiModelProperty(value = "ES4")
    private String es4;

    /**
     * ES5
     */
    @ApiModelProperty(value = "ES5")
    private String es5;

    /**
     * ES6
     */
    @ApiModelProperty(value = "ES6")
    private String es6;

    /**
     * ES7
     */
    @ApiModelProperty(value = "ES7")
    private String es7;

    /**
     * ES8
     */
    @ApiModelProperty(value = "ES8")
    private String es8;

    /**
     * ES9
     */
    @ApiModelProperty(value = "ES9")
    private String es9;

    /**
     * ES10
     */
    @ApiModelProperty(value = "ES10")
    private String es10;

    @ApiModelProperty(value = "经度")
    private String xLon;

    @ApiModelProperty(value = "纬度")
    private String yLat;

    @Override
    public Object[] waitHashContent() {
        return new Object[]{this.id};
    }
}
