package com.elitesland.support.provider.org.param;

import com.elitesland.support.provider.org.RpcBaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrgStoreAttachmentSaveRpcParam extends RpcBaseModel implements Serializable,DataHash {

    private static final long serialVersionUID = 9193720228489281697L;

    @ApiModelProperty(value = "组织ID")
    private Long orgId;

    @ApiModelProperty(value = "组织编号")
    private String orgCode;

    /**
     * 门店文件名称
     */
    @ApiModelProperty(value = "门店文件名称")
    private String fileName;

    /**
     * 门店文件编号
     */
    @ApiModelProperty(value = "门店文件编号")
    private String fileCode;

    /**
     * 图片尺寸
     */
    @ApiModelProperty(value = "图片尺寸")
    private String imgSize;

    /**
     * 文件大小
     */
    @ApiModelProperty(value = "文件大小")
    private String fileSize;

    /**
     * 文件类型，前端不需传该参数，后端会自动赋值
     */
    @ApiModelProperty(value = "文件类型，前端不需传该参数，后端会自动赋值")
    private String fileType;

    /**
     * 是否主图
     */
    @ApiModelProperty(value = "是否主图")
    private Boolean major;


    /**
     * 图片url
     */
    @ApiModelProperty(value = "图片url")
    private String url;

    /**
     * 图片顺序
     */
    @ApiModelProperty(value = "图片顺序")
    private Long fileOrder;

    @ApiModelProperty(value = "正式表ID")
    private Long oldId;

    @Override
    public Object[] waitHashContent() {
        return new Object[]{this.getId()};
    }
}
