package com.elitesland.support.provider.org.param.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("账户信息")
public class OrgBankAccount implements Serializable {
    private static final long serialVersionUID = 6654248833151483513L;

    @ApiModelProperty(value = "账户类型",
        notes = "1、IN：收款账号；2、OTHER：其他；3、OUT:付款账号")
    private String accType;

    @ApiModelProperty(value = "是否默认",
        notes = "1是，0否")
    private String defaultFlag;

    @ApiModelProperty(value = "收付款方式",
        notes = "1、ALIPAY：支付宝；2、ALIPAY_PRE：支付宝定金；3、CASH：现金收款；4、CNCP：第三方支付平台收款；" +
                "5、OFFLINE_PAY：线下支付；6、TT：银行转账；7、UNIONPAY：银联；8、UNIPAY_PRE：银联定金；" +
                "9、VIRTUAL：虚拟付款；10、WX：微信")
    private String payCollectMethod;

    @ApiModelProperty(value = "开户行")
    private String bankName;

    @ApiModelProperty(value = "支行")
    private String branchName;

    @ApiModelProperty(value = "账号")
    private String bankAcc;

    @ApiModelProperty(value = "户名")
    private String bankAccountName;

    @ApiModelProperty(value = "币种",
        notes = "1、CNY：人民币；2、USD：美元；3、JPY：日元；4、HKD：港币；5、EUR：欧元；6、GBP：英镑；6、AUD：澳元")
    private String currCode;
}
