package com.elitesland.support.provider.item.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.support.provider.Application;
import com.elitesland.support.provider.item.dto.ItmDeclareInspectDetailRpcDTO;
import com.elitesland.support.provider.item.dto.ItmDeclareInspectResultSaveDTO;
import com.elitesland.support.provider.item.dto.ItmDeclareInspectCreateDTO;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2025/10/23 周四
 */
@FeignClient(name = Application.NAME, path = ItmDeclareInspectRpcService.PATH)
public interface ItmDeclareInspectRpcService {
    String PATH = Application.PATH + "/declareInspect";

    @ApiOperation(value = "创建报检单")
    @PostMapping(value = "/create")
    ApiResult<String> createDeclareInspect(@RequestBody ItmDeclareInspectCreateDTO createDTO);

    @ApiOperation(value = "更新报检结果")
    @PostMapping(value = "/updateInspectResult")
    ApiResult<Long> updateInspectResult(@RequestBody ItmDeclareInspectResultSaveDTO saveDTO);

    @GetMapping(value = "/findById")
    @ApiOperation(value = "查询报检单信息")
    ApiResult<ItmDeclareInspectDetailRpcDTO> findById(@RequestParam(name = "id") Long id);

}
