package com.elitesland.support.provider.org.param;

import com.elitesland.support.provider.org.RpcBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * DTO for {@link com.elitesland.support.core.domain.entity.org.OrgBankDO}
 */
@Data
@ApiModel("银行信息")
public class OrgBankSaveRpcParam extends RpcBaseModel implements DataHash {
    @ApiModelProperty("关联主表ID")

    private Long masId;

    @ApiModelProperty("开户类型")

    private String type;

    @ApiModelProperty("开户名")

    private String name;

    @ApiModelProperty("结算身份证号")

    private String idCardNo;

    @ApiModelProperty("结算预留手机号")

    private String mobile;

    @ApiModelProperty("开户行名称")

    private String openBank;

    @ApiModelProperty("开户行支行名称")

    private String openBranchBank;

    @ApiModelProperty("结算卡号")

    private String cardNo;

    @ApiModelProperty("银行卡正面")

    private String cardFrontFileCode;

    @ApiModelProperty("银行卡正面url")

    private String cardFrontUrl;

    @ApiModelProperty("银行卡反面")

    private String cardBackFileCode;

    @ApiModelProperty("银行卡反面url")

    private String cardBackUrl;

    @ApiModelProperty("对公户结算账户开户支行联行号")

    private String unitedBankNo;

    @ApiModelProperty("开户许可证照片")

    private String licenceFileCode;

    @ApiModelProperty("开户许可证照片")

    private String licenceUrl;

    @ApiModelProperty("状态，ACTIVE：启用，CLOSED：停用")

    private String status;

    @ApiModelProperty(value = "正式表ID")
    private Long oldId;

    @Override
    public Object[] waitHashContent() {
        return new Object[]{this.getId()};
    }
}