package com.elitesland.support.provider.org.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("门店图片")
public class OrgStoreAttachmentDTO implements Serializable {
    private static final long serialVersionUID = 5342436137828117339L;
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 组织ID
     */
    @ApiModelProperty(value = "组织ID")
    private Long orgId;

    /**
     * 组织编号
     */
    @ApiModelProperty(value = "组织编号")
    private String orgCode;

    /**
     * 文件ID
     */
    @ApiModelProperty(value = "文件ID")
    private Long fileId;

    /**
     * 组织文件名称
     */
    @ApiModelProperty(value = "商品文件名称")
    private String fileName;

    /**
     * 组织文件编号
     */
    @ApiModelProperty(value = "商品文件编号")
    private String fileCode;

    /**
     * 组织文件类型(图片，附件等)
     */
    @ApiModelProperty(value = "商品文件类型(图片，附件等)")
    private String fileType;

    /**
     * 图片尺寸
     */
    @ApiModelProperty(value = "图片尺寸")
    private String imgSize;

    /**
     * 文件大小
     */
    @ApiModelProperty(value = "文件大小")
    private String fileSize;

    /**
     * 是否主图
     */
    @ApiModelProperty(value = "是否主图")
    private Boolean major;

    /**
     * 图片url
     */
    @ApiModelProperty(value = "图片url")
    private String url;

    /**
     * 图片顺序
     */
    @ApiModelProperty(value = "图片顺序")
    private Long fileOrder;

    /**
     * 图片主题
     */
    @ApiModelProperty(value = "图片主题")
    private String subject;

    /**
     * 正式表ID
     */
    @ApiModelProperty(value = "正式表ID")
    private Long oldId;
}
